// --------------------------------------------------------------------
// CUpInput.cpp
// Whatis:  Input Files
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpInput.h"
#include	"CUpFileType.h"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CUpInput::CUpInput	() {
	CUpInput::Cleanup();
}

// --------------------------------------------------------------------
CUpInput::~CUpInput	() {
	CUpInput::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CUpInput::CUpInput				( const CUpInput & aC ) {
	CUpInput::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CUpInput & CUpInput::operator =	( const CUpInput & aC ) {
	CUpInput::Free();
	itsFile		= aC.File();
	itsFileType	= aC.FileType();
	itsSelect	= aC.Select();
	return *this;
}

// --------------------------------------------------------------------
// public:	Comparison operators
// --------------------------------------------------------------------
bool CUpInput::operator == ( const CUpInput & aC ) const {
	return	::stricmp( CUpInput::File().PathName(), aC.File().PathName() ) == 0;
}

// --------------------------------------------------------------------
bool CUpInput::operator != ( const CUpInput & aC ) const {
	return	::stricmp( CUpInput::File().PathName(), aC.File().PathName() ) != 0;
}

// --------------------------------------------------------------------
// public:	Interface for the list management
// --------------------------------------------------------------------
bool			CUpInput::ListSelect	( void ) const {
	return	itsSelect;
}

// --------------------------------------------------------------------
void			CUpInput::ListSelect	( bool aV ) {
	itsSelect	= aV;
}

// --------------------------------------------------------------------
const char *	CUpInput::ListName		( void ) const {
	return	itsFile.PathName();
}

// --------------------------------------------------------------------
// public:	Streaming
// --------------------------------------------------------------------
void	CUpInput::Write		( CWinIniSection & aSec ) const {
	aSec.Insert( "FileType", 	itsFileType.Name() );
	aSec.Insert( "File", 		itsFile.PathName() );
	aSec.Insert( "Select", 		itsSelect );
}

// --------------------------------------------------------------------
void	CUpInput::Read		( const CWinIniFile &aIni, const char * aSecName ) {
	itsFileType.Name( aIni.Value( aSecName, "FileType" ) );
	itsFile.PathName( aIni.Value( aSecName, "File" ) );
	itsSelect = aIni.BoolValue( aSecName, "Select" );
}

// --------------------------------------------------------------------
// public:	Accessing instance data
// --------------------------------------------------------------------
const CUpFile &		CUpInput::File		( void ) const {
	return	itsFile;
}

// --------------------------------------------------------------------
const CUpFileType &	CUpInput::FileType	( void ) const {
	return	itsFileType;
}

// --------------------------------------------------------------------
bool				CUpInput::Select	( void ) const {
	return	itsSelect;
}

// --------------------------------------------------------------------
void				CUpInput::File		( const CUpFile & aC ) {
	itsFile = aC;
}

// --------------------------------------------------------------------
void				CUpInput::FileType	( const CUpFileType & aC ) {
	itsFileType = aC;
}

// --------------------------------------------------------------------
void				CUpInput::Select	( bool aV ) {
	itsSelect = aV;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void	CUpInput::Free		( void ) {
	CUpInput::Cleanup();
}

// --------------------------------------------------------------------
void	CUpInput::Cleanup	( void ) {
	itsFile.PathName( NULL );
	itsSelect = false;
}

// --------------------------------------------------------------------
// EOF:	CUpInput.cpp
// --------------------------------------------------------------------
