//---------------------------------------------------------------------------
// TUpDialogArchiveZip.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpDialog.h"

//---------------------------------------------------------------------------
#define	SELITEM(l)		l->Items->Strings[l->ItemIndex].c_str()
#define	IDXITEM(l,i)	l->Items->Strings[i].c_str()
#define	IDXIREF(l,i)	l->Items->Strings[i]

//---------------------------------------------------------------------------
// local:	Thread for package searcher
//---------------------------------------------------------------------------
static int	__fastcall	MyPackageLoader( void * aDoc ) {
	CUpDoc *	myDoc = (CUpDoc *)aDoc;
    myDoc->FindMissingPacks();
    return	0;
}

//---------------------------------------------------------------------------
// local:	Thread for zipping a file
//---------------------------------------------------------------------------
static int	__fastcall	MyZipThread( void * aDoc ) {
	CUpDoc *	myDoc = (CUpDoc *)aDoc;
    myDoc->WriteIntoZip();
    return	0;
}

//---------------------------------------------------------------------------
// local:	Thread for G-zipping a file
//---------------------------------------------------------------------------
static int	__fastcall	MyGZipThread( void * aDoc ) {
	CUpDoc *	myDoc = (CUpDoc *)aDoc;
    myDoc->WriteIntoGZip();
    return	0;
}

//---------------------------------------------------------------------------
// local:	Thread for Uz-zipping a file
//---------------------------------------------------------------------------
static int	__fastcall	MyUzThread( void * aDoc ) {
	CUpDoc *	myDoc = (CUpDoc *)aDoc;
    myDoc->WriteIntoUz();
    return	0;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateArchiveZip(TObject *Sender)
{
	itsUpdateFlag++;
    bool	myEnable = itsDoc.InputList().size() > 0;

    ArchiveZipCommentNewBitBtn->Enabled    = myEnable;
    ArchiveZipCommentOpenBitBtn->Enabled   = myEnable;
    ArchiveZipCommentSaveBitBtn->Enabled   = myEnable;
    ArchiveZipCommentWizardBitBtn->Enabled = myEnable;
    ArchiveZipSaveButton->Enabled          = myEnable;

    TUpDialog::SetControlEnable( ArchiveZipPathnamesRadioGroup, myEnable );
    TUpDialog::SetControlEnable( ArchiveZipCompressionRadioGroup, myEnable );
    TUpDialog::SetControlEnable( ArchiveZipCommentMemo, myEnable );
    if	( myEnable ) {
	    ArchiveZipPathnamesRadioGroup->ItemIndex	= itsDoc.ZipPathMode();
		ArchiveZipCompressionRadioGroup->ItemIndex	= itsDoc.ZipCompressMode();
	    ArchiveZipCommentMemo->Lines->Text			= itsDoc.ZipComment();
	    ArchiveZipCommentSaveBitBtn->Enabled		= ArchiveZipCommentMemo->Lines->Text != "";
	    ArchiveZipCommentNewBitBtn->Enabled			= ArchiveZipCommentMemo->Lines->Text != "";
    }
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateArchiveGZip(TObject *Sender)
{
	itsUpdateFlag++;
    bool	myEnable = itsDoc.InputList().size() > 0;

    ArchiveGZipNewReadmeBitBtn->Enabled     = myEnable;
    ArchiveGZipOpenReadmeBitBtn->Enabled    = myEnable;
    ArchiveGZipSaveReadmeBitBtn->Enabled    = myEnable;
    ArchiveGZipCommentWizardBitBtn->Enabled = myEnable;
    ArchiveGZipSaveButton->Enabled          = myEnable;

    TUpDialog::SetControlEnable( ArchiveGZipPathRadioGroup, myEnable );
    TUpDialog::SetControlEnable( ArchiveGZipCompressionRadioGroup, myEnable );
    TUpDialog::SetControlEnable( ArchiveGZipReadmeMemo, myEnable );

    if	( myEnable ) {
		ArchiveGZipPathRadioGroup->ItemIndex        = itsDoc.GZipPathMode();
	    ArchiveGZipCompressionRadioGroup->ItemIndex = itsDoc.GZipCompressMode();
	    ArchiveGZipReadmeMemo->Lines->Text			= itsDoc.GZipComment();
	    ArchiveGZipSaveReadmeBitBtn->Enabled		= ArchiveGZipReadmeMemo->Lines->Text != "";
	    ArchiveGZipNewReadmeBitBtn->Enabled			= ArchiveGZipReadmeMemo->Lines->Text != "";
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateArchiveUz(TObject *Sender)
{
	itsUpdateFlag++;

    bool	enabled;

    // Must we pick up the uz2 mode ?
    if	( itsDoc.UzMode() == 0 ) {
		if	( ! itsDoc.CanUseUz1() ) {
        	itsDoc.UzMode( 1 );
        }
    }

    // Check out if the given mode is supported
    if		( itsDoc.UccExecutable( itsDoc.UzMode() ) )	{
    	enabled = true;
    }
    else if	( ( itsDoc.UccExecutable( 0 ) ) && ( itsDoc.CanUseUz1() ) ) {
		itsDoc.UzMode( 0 );
   		enabled = true;
    }
    else if	( itsDoc.UccExecutable( 1 ) ) {
		itsDoc.UzMode( 1 );
    	enabled = true;
    }
    else {
    	enabled = false;
    }

	if	( ! enabled ) {
	    TUpDialog::SetControlEnable( UzModeRadioGroup, enabled );
    	TUpDialog::SetControlEnable( UzSkipNopacksCheckBox, enabled );
    	TUpDialog::SetControlEnable( UzIncrementalCheckBox, enabled );
	    RepositoryDeleteBitBtn->Enabled = enabled;
    	TUpDialog::SetControlEnable( RepositoryFolderPanel, enabled );
	    RepositoryBrowseBitBtn->Enabled = enabled;
    	TUpDialog::SetControlEnable( RepositoryListBox, enabled );
	    SaveUzButton->Enabled = enabled;
    }

    else {
	    TUpDialog::SetControlEnable( UzModeRadioGroup, enabled );
       	UzModeRadioGroup->ItemIndex = itsDoc.UzMode();

    	TUpDialog::SetControlEnable( UzSkipNopacksCheckBox, enabled );
        UzSkipNopacksCheckBox->Checked = itsDoc.UzSkipNoPack();

      	TUpDialog::SetControlEnable( UzIncrementalCheckBox, enabled );
        UzIncrementalCheckBox->Checked = itsDoc.UzIncremental();

    	TUpDialog::SetControlEnable( RepositoryFolderPanel, enabled );
        RepositoryFolderPanel->Caption = 	itsDoc.UzMode() == 0
        									? itsDoc.UzRepository()
                                            : itsDoc.Uz2Repository();

	    RepositoryBrowseBitBtn->Enabled = enabled;

        RepositoryDeleteBitBtn->Enabled = (RepositoryListBox->SelCount > 0);
    	TUpDialog::SetControlEnable( RepositoryListBox, RepositoryFolderPanel->Caption != "" );
	    SaveUzButton->Enabled = ( RepositoryFolderPanel->Caption != "" &&
        						  itsDoc.InputList().size() > 0 );

        // Fill in the file list box as needed (also show date and time for each file)
		if	( RepositoryFolderPanel->Caption != "" ) {
			TSearchRec	sr;
   	        struct stat mystat;
	    	char		wild	[512];
       	  	char		myfile	[512];

	        ::sprintf(	wild, "%s\\*.%s",
                        RepositoryFolderPanel->Caption.c_str(),
                        itsDoc.UzMode() == 0 ? "uz" : "uz2" );

			RepositoryListBox->Items->Clear();
		    if	( FindFirst( wild, faReadOnly|faHidden|faSysFile|faArchive, sr ) == 0 ) {
				do {
					if	( sr.Name == "." )	continue;
        	        if	( sr.Name == ".." )	continue;
					::sprintf( myfile, "%s\\%s", RepositoryFolderPanel->Caption.c_str(), sr.Name.c_str() );
					if	( ::stat( myfile, &mystat ) != 0 )	continue;
					RepositoryListBox->Items->Add( myfile );
	            }	while ( FindNext( sr ) == 0 );
            }
			FindClose( sr );
        }
    }

	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipPathnamesRadioGroupClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsDoc.ZipPathMode( ArchiveZipPathnamesRadioGroup->ItemIndex );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipCompressionRadioGroupClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsDoc.ZipCompressMode( ArchiveZipCompressionRadioGroup->ItemIndex );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipCommentMemoChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ZipComment( ArchiveZipCommentMemo->Lines->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipCommentNewBitBtnClick(TObject *Sender)
{
	itsDoc.ZipComment( "" );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipCommentOpenBitBtnClick(TObject *Sender)
{
	itsUpdateFlag++;
	TUpDialog::LoadMyMemo( ArchiveZipCommentMemo );
	itsDoc.ZipComment( ArchiveZipCommentMemo->Lines->Text.c_str() );
	itsUpdateFlag--;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipCommentSaveBitBtnClick(TObject *Sender)
{
	TUpDialog::SaveMyMemo( ArchiveZipCommentMemo );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipPathRadioGroupClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsDoc.GZipPathMode( ArchiveGZipPathRadioGroup->ItemIndex );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipCompressionRadioGroupClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsDoc.GZipCompressMode( ArchiveGZipCompressionRadioGroup->ItemIndex );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipReadmeMemoChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.GZipComment( ArchiveGZipReadmeMemo->Lines->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipNewReadmeBitBtnClick(TObject *Sender)
{
	itsDoc.GZipComment( "" );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipOpenReadmeBitBtnClick(TObject *Sender)
{
	itsUpdateFlag++;
	TUpDialog::LoadMyMemo( ArchiveGZipReadmeMemo );
	itsDoc.GZipComment( ArchiveGZipReadmeMemo->Lines->Text.c_str() );
	itsUpdateFlag--;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipSaveReadmeBitBtnClick(TObject *Sender)
{
	TUpDialog::SaveMyMemo( ArchiveGZipReadmeMemo );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipSaveButtonClick(TObject *Sender)
{
	// Start saving the zip
	char *	filename;
    filename = TUpDialog::SaveFileQuery( "*.zip", itsDoc.InputListMapFile().File().FileName() );
    if	( filename ) {
		::unlink( filename );
        itsDoc.SetArchiveFileName( filename );
        delete [] filename;

		// Here we go with the zip !
		TUpDialog::ZipComprProgress( MyZipThread );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipSaveButtonClick(TObject *Sender)
{
	// Start saving the tar.gz or tar
	char *	filename;

    switch	( ArchiveGZipCompressionRadioGroup->ItemIndex ) {
    	case	0:	// Use best available compression (normal tar.gz)
	    filename = TUpDialog::SaveFileQuery( "*.tar.gz", itsDoc.InputListMapFile().File().FileName() );
        break;

    	case	1:	// No compression (tar only)
	    filename = TUpDialog::SaveFileQuery( "*.tar", itsDoc.InputListMapFile().File().FileName() );
        break;
    }
    if	( filename ) {
		::unlink( filename );
        itsDoc.SetArchiveFileName( filename );
        delete [] filename;

		// Here we go with the zip !
		TUpDialog::ZipComprProgress( MyGZipThread );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveZipCommentWizardBitBtnClick(
      TObject *Sender)
{
	char *	wizardtext;
    wizardtext = itsDoc.GenerateReadme( );
	if	( wizardtext ) {
		itsDoc.ZipComment( wizardtext );
		delete [] wizardtext;
	    TUpDialog::Populate( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchiveGZipCommentWizardBitBtnClick(
      TObject *Sender)
{
	char *	wizardtext;
    wizardtext = itsDoc.GenerateReadme( );
	if	( wizardtext ) {
		itsDoc.GZipComment( wizardtext );
		delete [] wizardtext;
	    TUpDialog::Populate( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateWizard(TObject *Sender) {
	if		( WizardAllFilesCheckBox->Checked ) {
    	WizardArchiveNameEdit->Text = "";
    	if	( WizardFileListBox->Items->Count > 0 ) {
    	    WizardZipButton->Enabled	= true;
        	WizardGzipButton->Enabled	= true;
        	WizardUzButton->Enabled		= itsDoc.UzAvailable();
        }
        else {
    	    WizardZipButton->Enabled	= false;
        	WizardGzipButton->Enabled	= false;
        	WizardUzButton->Enabled		= false;
        }
    }
	else if	( WizardFileNameEdit->Text == "*.ut2;*.unr" ) {
    	WizardArchiveNameEdit->Text = "";
        WizardZipButton->Enabled	= false;
        WizardGzipButton->Enabled	= false;
       	WizardUzButton->Enabled		= false;
    }
    else {
		char	mypath	[512];
		char	mydrive	[20];
	    char	mydir	[256];
	    char	myfile	[256];
	    ::strcpy( mypath, WizardFileListBox->Directory.c_str() );
	    ::strcat( mypath, "\\" );
	    ::strcat( mypath, WizardFileNameEdit->Text.c_str() );
		::fnsplit( mypath, mydrive, mydir, myfile, NULL );

        if	( itsDoc.IsDeniedFile( myfile ) ) {
	    	WizardArchiveNameEdit->Text = "";
	        WizardZipButton->Enabled	= false;
    	    WizardGzipButton->Enabled	= false;
        	WizardUzButton->Enabled		= false;
        }
        else {
	        ::strlwr( myfile );
			::fnmerge( mypath, mydrive, mydir, myfile, NULL );
    		WizardArchiveNameEdit->Text = mypath;
        	WizardZipButton->Enabled	= true;
        	WizardGzipButton->Enabled	= true;
	       	WizardUzButton->Enabled		= itsDoc.UzAvailable();
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::WizardFileNameEditChange(TObject *Sender) {
	TUpDialog::PopulateWizard(Sender);
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::WizardSetWizardFile( const char * aFile ) {
	itsDoc.InputListClear();
	if	( itsDoc.IsDeniedFile( aFile ) ) {
   		WizardArchiveNameEdit->Text = "";
    }
    else {
		char	mypath	[512];
		char	mydrive	[20];
	    char	mydir	[256];
	    char	myfile	[256];
	    ::strcpy( mypath, WizardFileListBox->Directory.c_str() );
	    ::strcat( mypath, "\\" );
	    ::strcat( mypath, aFile );
		itsDoc.AddInputFile( mypath );

		::fnsplit( mypath, mydrive, mydir, myfile, NULL );
        ::strlwr( myfile );
		::fnmerge( mypath, mydrive, mydir, myfile, NULL );

   		WizardArchiveNameEdit->Text = mypath;

		TUpDialog::DocumentProgress( MyPackageLoader, "Searching for packages" );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::WizardZipButtonClick(TObject *Sender)
{	// Create the zip with wizard
	itsDoc.PathListInsert( WizardFileListBox->Directory.c_str() );
    itsDoc.PathListSelect( WizardFileListBox->Directory.c_str(), true );
    itsDoc.DefaultPaths( WizardFileListBox->Directory.c_str() );

	TUpDialog::PopulateArchiveZip( Sender );
	if	( WizardAllFilesCheckBox->Checked ) {
		int		ix;
        for	( ix = 0; ix < WizardFileListBox->Items->Count; ix++ ) {
			TUpDialog::WizardSetWizardFile( IDXITEM( WizardFileListBox, ix) );
   			if	( WizardArchiveNameEdit->Text != "" ) {
				char	filepath[512];
				::strcpy( filepath, WizardArchiveNameEdit->Text.c_str() );
		    	::strcat( filepath, ".zip" );
				::unlink( filepath );
			    itsDoc.SetArchiveFileName( filepath );
				TUpDialog::ZipComprProgress( MyZipThread );
                if	( itsDoc.ZipProgress().Aborting() )	break;
            }
        }
    }
    else {
		char	filepath[512];
		itsDoc.InputListClear();
		::strcpy( filepath, WizardFileListBox->Directory.c_str() );
	    ::strcat( filepath, "\\" );
	    ::strcat( filepath, WizardFileNameEdit->Text.c_str() );
		itsDoc.AddInputFile( filepath );
		TUpDialog::DocumentProgress( MyPackageLoader, "Searching for packages" );

		::strcpy( filepath, WizardArchiveNameEdit->Text.c_str() );
	    ::strcat( filepath, ".zip" );
		::unlink( filepath );
	    itsDoc.SetArchiveFileName( filepath );
		TUpDialog::ZipComprProgress( MyZipThread );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::WizardGzipButtonClick(TObject *Sender)
{	// Create the GZip with wizard
	itsDoc.PathListInsert( WizardFileListBox->Directory.c_str() );
    itsDoc.PathListSelect( WizardFileListBox->Directory.c_str(), true );
    itsDoc.DefaultPaths( WizardFileListBox->Directory.c_str() );

	TUpDialog::PopulateArchiveGZip( Sender );
	if	( WizardAllFilesCheckBox->Checked ) {
		int		ix;
        for	( ix = 0; ix < WizardFileListBox->Items->Count; ix++ ) {
			TUpDialog::WizardSetWizardFile( IDXITEM( WizardFileListBox, ix) );
   			if	( WizardArchiveNameEdit->Text != "" ) {
				char	filepath[512];
				::strcpy( filepath, WizardArchiveNameEdit->Text.c_str() );
		    	switch	( ArchiveGZipCompressionRadioGroup->ItemIndex ) {
    				case	0:	// Use best available compression (normal tar.gz)
				    ::strcat( filepath, ".tar.gz" );
    			    break;

			    	case	1:	// No compression (tar only)
				    ::strcat( filepath, ".tar" );
		        	break;
	    		}
				::unlink( filepath );
	    		itsDoc.SetArchiveFileName( filepath );

				TUpDialog::ZipComprProgress( MyGZipThread );
                if	( itsDoc.ZipProgress().Aborting() )	break;
			}
        }
	}
    else {
		char	filepath[512];
		itsDoc.InputListClear();
		::strcpy( filepath, WizardFileListBox->Directory.c_str() );
	    ::strcat( filepath, "\\" );
    	::strcat( filepath, WizardFileNameEdit->Text.c_str() );
		itsDoc.AddInputFile( filepath );
		TUpDialog::DocumentProgress( MyPackageLoader, "Searching for packages" );

		::strcpy( filepath, WizardArchiveNameEdit->Text.c_str() );
    	switch	( ArchiveGZipCompressionRadioGroup->ItemIndex ) {
    		case	0:	// Use best available compression (normal tar.gz)
		    ::strcat( filepath, ".tar.gz" );
    	    break;

	    	case	1:	// No compression (tar only)
		    ::strcat( filepath, ".tar" );
        	break;
	    }
		::unlink( filepath );
	    itsDoc.SetArchiveFileName( filepath );

		TUpDialog::ZipComprProgress( MyGZipThread );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::WizardUzButtonClick(TObject *Sender)
{	// Create the Uz files with wizard
	itsDoc.PathListInsert( WizardFileListBox->Directory.c_str() );
    itsDoc.PathListSelect( WizardFileListBox->Directory.c_str(), true );
    itsDoc.DefaultPaths( WizardFileListBox->Directory.c_str() );

	if	( WizardAllFilesCheckBox->Checked ) {
		int		ix;
        for	( ix = 0; ix < WizardFileListBox->Items->Count; ix++ ) {
			TUpDialog::WizardSetWizardFile( IDXITEM( WizardFileListBox, ix) );
   			if	( WizardArchiveNameEdit->Text != "" ) {
				TUpDialog::ZipComprProgress( MyUzThread );
                if	( itsDoc.ZipProgress().Aborting() )	break;
			}
        }
	}
    else {
		char	filepath[512];
		itsDoc.InputListClear();
		::strcpy( filepath, WizardFileListBox->Directory.c_str() );
	    ::strcat( filepath, "\\" );
    	::strcat( filepath, WizardFileNameEdit->Text.c_str() );
		itsDoc.AddInputFile( filepath );
		TUpDialog::DocumentProgress( MyPackageLoader, "Searching for packages" );
		TUpDialog::ZipComprProgress( MyUzThread );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::UzModeRadioGroupClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsUpdateFlag++;
    itsDoc.UzMode( UzModeRadioGroup->ItemIndex );
    itsUpdateFlag--;
	TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::UzSkipNopacksCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsUpdateFlag++;
	itsDoc.UzSkipNoPack( UzSkipNopacksCheckBox->Checked );
    itsUpdateFlag--;
	TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::UzIncrementalCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsUpdateFlag++;
	itsDoc.UzIncremental( UzIncrementalCheckBox->Checked );
    itsUpdateFlag--;
	TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::RepositoryBrowseBitBtnClick(TObject *Sender)
{
	char *	directory = TUpDialog::DirectoryQuery ( "Select repository" );
	if	( directory ) {
    	if	( itsDoc.UzMode() )	itsDoc.Uz2Repository( directory );
        else					itsDoc.UzRepository( directory );
		delete [] directory;
		TUpDialog::Populate( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::RepositoryListBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsUpdateFlag++;
    RepositoryDeleteBitBtn->Enabled = (RepositoryListBox->SelCount > 0);
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::RepositoryDeleteBitBtnClick(TObject *Sender)
{
	for	( int i = 0; i < RepositoryListBox->Items->Count; i++ ) {
    	if	( RepositoryListBox->Selected[i] ) {
        	::unlink( RepositoryListBox->Items->Strings[i].c_str() );
        }
    }

	TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SaveUzButtonClick(TObject *Sender)
{
	// Start saving the uz
	TUpDialog::ZipComprProgress( MyUzThread );
	TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
// EOF: TUpDialogArchiveZip.cpp
//---------------------------------------------------------------------------
