//---------------------------------------------------------------------------
// TUpDialogProject.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpDialog.h"
#include "TUpReadmePreviewDialog.h"

//---------------------------------------------------------------------------
#define	SELITEM(l)		l->Items->Strings[l->ItemIndex].c_str()
#define	IDXITEM(l,i)	l->Items->Strings[i].c_str()
#define	IDXIREF(l,i)	l->Items->Strings[i]

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateProject(TObject *Sender)
{	// Populate project leaf
	ProjectSaveBitBtn->Enabled 		= itsDoc.Dirty();
    ProjectProjectPanel->Caption	= itsDoc.ProjectFile().FullName();
    TUpDialog::ProjectPageControlChange( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectPageControlChange(TObject *Sender)
{	// Update as page changed
	if		( ProjectPageControl->ActivePage == ProjectPageControl->Pages[0] ) {
    	TUpDialog::PopulateProjectPaths( Sender );
    }
	else if	( ProjectPageControl->ActivePage == ProjectPageControl->Pages[1] ) {
    	TUpDialog::PopulateProjectDeny( Sender );
    }
	else if	( ProjectPageControl->ActivePage == ProjectPageControl->Pages[2] ) {
    	TUpDialog::PopulateProjectFileTypes( Sender );
    }
	else if	( ProjectPageControl->ActivePage == ProjectPageControl->Pages[3] ) {
    	TUpDialog::PopulateProjectReadme( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateProjectPaths(TObject *Sender)
{
    TUpDialog::ManageCheckBoxList( ProjectPathsCheckListBox, &(itsDoc.PathList()) );

    ProjectPathsAddBitBtn->Enabled      = ProjectPathsPathPanel->Caption != "" &&
    									  itsDoc.PathListExist( ProjectPathsPathPanel->Caption.c_str() ) == false;
    ProjectPathsMoveUpBitBtn->Enabled	= ProjectPathsCheckListBox->ItemIndex > 0;
    ProjectPathsMoveDnBitBtn->Enabled   = ProjectPathsCheckListBox->ItemIndex >= 0 &&
                                          ProjectPathsCheckListBox->ItemIndex < ProjectPathsCheckListBox->Items->Count - 1;
    ProjectPathsDeleteBitBtn->Enabled   = ProjectPathsCheckListBox->ItemIndex >= 0;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateProjectDeny(TObject *Sender)
{
    TUpDialog::ManageCheckBoxList( ProjectDenyCheckListBox, &(itsDoc.DenyList()) );

    ProjectDenyAddBitBtn->Enabled       = ProjectDenyFileListBox->SelCount > 0;
    ProjectDenyDeleteBitBtn->Enabled	= ProjectDenyCheckListBox->ItemIndex >= 0;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateProjectFileTypes(TObject *Sender)
{
    TUpDialog::ManageCheckBoxList( ProjectFileTypeCheckListBox, &(itsDoc.FileTypeList()) );

	ProjectFileTypeDeleteBitBtn->Enabled	= ProjectFileTypeCheckListBox->ItemIndex >= 0;
    ProjectFileTypeUpBitBtn->Enabled        = ProjectFileTypeCheckListBox->ItemIndex > 0;
    ProjectFileTypeDownBitBtn->Enabled      = ProjectFileTypeCheckListBox->ItemIndex >= 0 &&
                                              ProjectFileTypeCheckListBox->ItemIndex < ProjectFileTypeCheckListBox->Items->Count - 1;

    bool	myEnable;
    myEnable = ProjectFileTypeCheckListBox->ItemIndex >= 0;
    ProjectFileTypesRulesAddBitBtn->Enabled = myEnable;
    TUpDialog::SetControlEnable( ProjectFileTypesNameEdit, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesRuleComboBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesRulesMemo, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesTargetDirEdit, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesAutoSearchCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesUz2OnlyCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesAutoSearchEdit, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneUnrealCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneShotCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneTextCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneLevelInfoCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneTexturesCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneHtmlCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneHexDumpCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPanePictureCheckBox, myEnable );
    TUpDialog::SetControlEnable( ProjectFileTypesPPaneFileCheckBox, myEnable );
    if	( ! myEnable )	return;

    // Get the file type for updating the details
    CUpFileType	mytype;
	itsUpdateFlag++;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
    ProjectFileTypesNameEdit->Text					= mytype.Name();
    ProjectFileTypesRulesMemo->Lines->Text			= mytype.Rules();
    ProjectFileTypesTargetDirEdit->Text             = mytype.TargetDir();
    ProjectFileTypesAutoSearchCheckBox->Checked     = mytype.AutoSearch();
    ProjectFileTypesUz2OnlyCheckBox->Checked     	= mytype.Uz2Only();
    ProjectFileTypesAutoSearchEdit->Text            = mytype.Suffixes();
    ProjectFileTypesPPaneUnrealCheckBox->Checked    = mytype.PaneUnreal();
    ProjectFileTypesPPaneLevelInfoCheckBox->Checked = mytype.PaneLevel();
    ProjectFileTypesPPaneHexDumpCheckBox->Checked   = mytype.PaneHexdump();
    ProjectFileTypesPPaneShotCheckBox->Checked      = mytype.PaneScreenshot();
    ProjectFileTypesPPaneTexturesCheckBox->Checked  = mytype.PaneTextures();
    ProjectFileTypesPPanePictureCheckBox->Checked   = mytype.PanePicture();
    ProjectFileTypesPPaneTextCheckBox->Checked      = mytype.PaneText();
    ProjectFileTypesPPaneHtmlCheckBox->Checked      = mytype.PaneHtml();
    ProjectFileTypesPPaneFileCheckBox->Checked      = mytype.PaneFile();
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectNewBitBtnClick(TObject *Sender)
{
	if	( itsDoc.Dirty() ) {
    	if	( ! TUpDialog::CanDisposeChanges( "Erase document anyway ?" ) ) {
        	return;
        }
    }
	itsDoc.NewDoc( Application->ExeName.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectOpenBitBtnClick(TObject *Sender)
{
	if	( itsDoc.Dirty() ) {
    	if	( ! TUpDialog::CanDisposeChanges( "Open a document anyway ?" ) ) {
        	return;
        }
    }

	char *	filename;
    filename = TUpDialog::OpenFileQuery( "*.upp" );

    if	( filename ) {
		itsDoc.NewDoc( Application->ExeName.c_str() );
    	itsDoc.Read( filename );
        itsDoc.ProjectFile().PathName( filename );
        itsDoc.Dirty( false );
		delete [] filename;
	    TUpDialog::Populate( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectSaveBitBtnClick(TObject *Sender)
{
	char *	filename;
    if	( itsDoc.ProjectFile().FileName()[0] == 0 ) {
		itsDoc.ProjectFile().PathName( itsDoc.InputListMapFile().File().PathName() );
    }

    filename = TUpDialog::SaveFileQuery( "*.upp", itsDoc.ProjectFile().FileName() );
    if	( filename ) {
		::unlink( filename );
        itsDoc.ProjectFile().PathName( filename );
    	itsDoc.Write( filename );
        itsDoc.Dirty( false );
		delete [] filename;
	    TUpDialog::Populate( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectPathsDirectoryListBoxClick(TObject *Sender)
{
	ProjectPathsPathPanel->Caption = ProjectPathsDirectoryListBox->Directory;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectPathsAddBitBtnClick(TObject *Sender)
{
	itsDoc.PathListInsert( ProjectPathsPathPanel->Caption.c_str() );
    itsDoc.PathListSelect( ProjectPathsPathPanel->Caption.c_str(), true );
    itsDoc.DefaultPaths( ProjectPathsPathPanel->Caption.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectPathsCheckListBoxClickCheck(TObject *Sender)
{
	TUpDialog::ChkClkCheckBoxList( ProjectPathsCheckListBox, (void *)(&(itsDoc.PathList())) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectPathsMoveUpBitBtnClick(TObject *Sender)
{
	if	( ProjectPathsCheckListBox->ItemIndex < 1 )	return;
    itsDoc.PathListUp( SELITEM( ProjectPathsCheckListBox ) );
    ProjectPathsCheckListBox->ItemIndex = ProjectPathsCheckListBox->ItemIndex - 1;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectPathsMoveDnBitBtnClick(TObject *Sender)
{
	if	( ProjectPathsCheckListBox->ItemIndex < 0 )	return;
	if	( ProjectPathsCheckListBox->ItemIndex >= ProjectPathsCheckListBox->Items->Count - 1 )	return;
    itsDoc.PathListDown( SELITEM( ProjectPathsCheckListBox ) );
    ProjectPathsCheckListBox->ItemIndex = ProjectPathsCheckListBox->ItemIndex + 1;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectPathsDeleteBitBtnClick(TObject *Sender)
{
	if	( ProjectPathsCheckListBox->ItemIndex < 0 )	return;
    itsDoc.PathListDelete( SELITEM( ProjectPathsCheckListBox ) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectDenyAddBitBtnClick(TObject *Sender)
{
	int		item;
	char	filename[512];

    for	( item = 0; item < ProjectDenyFileListBox->Items->Count; item++ ) {
    	if	( ProjectDenyFileListBox->Selected[item] ) {
			::fnsplit( IDXITEM( ProjectDenyFileListBox, item ), NULL, NULL, filename, NULL );
			::strlwr( filename );
			itsDoc.DenyListInsert( filename );
		    itsDoc.DenyListSelect( filename, true );
        }
    }
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectDenyCheckListBoxClickCheck(
      TObject *Sender)
{
	TUpDialog::ChkClkCheckBoxList( ProjectDenyCheckListBox, (void *)(&(itsDoc.DenyList())) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectDenyDeleteBitBtnClick(TObject *Sender)
{
	if	( ProjectDenyCheckListBox->ItemIndex < 0 )	return;
    itsDoc.DenyListDelete( SELITEM( ProjectDenyCheckListBox ) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypeCheckListBoxClickCheck(
      TObject *Sender)
{
	TUpDialog::ChkClkCheckBoxList( ProjectFileTypeCheckListBox, (void *)(&(itsDoc.FileTypeList())) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypeNewBitBtnClick(TObject *Sender)
{
	CUpFileType	mytype;
    mytype.Name( "Untitled" );
    mytype.Select( true );
    itsDoc.FileTypeListInsert( mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypeDeleteBitBtnClick(
      TObject *Sender)
{
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;
    itsDoc.FileTypeListDelete( SELITEM( ProjectFileTypeCheckListBox ) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypeUpBitBtnClick(TObject *Sender)
{
	if	( ProjectFileTypeCheckListBox->ItemIndex < 1 )	return;
    itsDoc.FileTypeListUp( SELITEM( ProjectFileTypeCheckListBox ) );
    ProjectFileTypeCheckListBox->ItemIndex = ProjectFileTypeCheckListBox->ItemIndex - 1;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypeDownBitBtnClick(TObject *Sender)
{
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex >= ProjectFileTypeCheckListBox->Items->Count - 1 )	return;
    itsDoc.FileTypeListDown( SELITEM( ProjectFileTypeCheckListBox ) );
    ProjectFileTypeCheckListBox->ItemIndex = ProjectFileTypeCheckListBox->ItemIndex + 1;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesNameEditChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;
	if	( itsDoc.FileTypeListExist( ProjectFileTypesNameEdit->Text.c_str() ) ) return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.Name( ProjectFileTypesNameEdit->Text.c_str() );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesRulesAddBitBtnClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;
	if	( ProjectFileTypesRuleComboBox->ItemIndex < 0 )	return;
    ProjectFileTypesRulesMemo->SetSelTextBuf( SELITEM( ProjectFileTypesRuleComboBox ) );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesRulesMemoChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.Rules( ProjectFileTypesRulesMemo->Lines->Text.c_str() );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesTargetDirEditChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.TargetDir( ProjectFileTypesTargetDirEdit->Text.c_str() );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesAutoSearchCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.AutoSearch( ProjectFileTypesAutoSearchCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesUz2OnlyCheckBoxClick(
      TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.Uz2Only( ProjectFileTypesUz2OnlyCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesAutoSearchEditChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.Suffixes( ProjectFileTypesAutoSearchEdit->Text.c_str() );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneUnrealCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneUnreal( ProjectFileTypesPPaneUnrealCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneLevelInfoCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneLevel( ProjectFileTypesPPaneLevelInfoCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneHexDumpCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneHexdump( ProjectFileTypesPPaneHexDumpCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneShotCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneScreenshot( ProjectFileTypesPPaneShotCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneTexturesCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneTextures( ProjectFileTypesPPaneTexturesCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPanePictureCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PanePicture( ProjectFileTypesPPanePictureCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneTextCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneText( ProjectFileTypesPPaneTextCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneHtmlCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneHtml( ProjectFileTypesPPaneHtmlCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectFileTypesPPaneFileCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	if	( ProjectFileTypeCheckListBox->ItemIndex < 0 )	return;

    CUpFileType	mytype;
    mytype = itsDoc.FileTypeListItem( SELITEM( ProjectFileTypeCheckListBox ) );
	mytype.PaneFile( ProjectFileTypesPPaneFileCheckBox->Checked );
    itsDoc.FileTypeListUpdate( SELITEM( ProjectFileTypeCheckListBox ), mytype );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateProjectReadme(TObject *Sender)
{
	itsUpdateFlag++;
	ProjectReadmeNameEdit->Text        = itsDoc.ReadmeName();
    ProjectReadmeEmailEdit->Text       = itsDoc.ReadmeEmail();
    ProjectReadmeWebsiteEdit->Text     = itsDoc.ReadmeWebsite();
    ProjectReadmeRadioGroup->ItemIndex = itsDoc.ReadmeNaming();
    ProjectReadmeFileNameEdit->Text    = itsDoc.ReadmeFileName();
    ProjectReadmeHtmlCheckBox->Checked = itsDoc.ReadmeHtml();
    ProjectReadmeMemo->Lines->Text     = itsDoc.ReadmeText();
    ProjectReadmeNewBitBtn->Enabled    = ProjectReadmeMemo->Lines->Text != "";
    ProjectReadmeSaveBitBtn->Enabled   = ProjectReadmeMemo->Lines->Text != "";
    ProjectReadmePreviewBitBtn->Enabled= ProjectReadmeMemo->Lines->Text != "";
    if	( itsDoc.ReadmeNaming() == 2 ) {
    	ProjectReadmeFileNameEdit->Color   = clWindow;
        ProjectReadmeFileNameEdit->Enabled = true;
    }
    else {
    	ProjectReadmeFileNameEdit->Color   = clBtnFace;
        ProjectReadmeFileNameEdit->Enabled = false;
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeNameEditChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ReadmeName( ProjectReadmeNameEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeEmailEditChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ReadmeEmail( ProjectReadmeEmailEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeWebsiteEditChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ReadmeWebsite( ProjectReadmeWebsiteEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeRadioGroupClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ReadmeNaming( ProjectReadmeRadioGroup->ItemIndex );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeFileNameEditChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ReadmeFileName( ProjectReadmeFileNameEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeMemoChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ReadmeText( ProjectReadmeMemo->Lines->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeHtmlCheckBoxClick(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
	itsDoc.ReadmeHtml( ProjectReadmeHtmlCheckBox->Checked );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeNewBitBtnClick(TObject *Sender)
{
	itsDoc.ReadmeText( "" );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeOpenBitBtnClick(TObject *Sender)
{
	itsUpdateFlag++;
	TUpDialog::LoadMyMemo( ProjectReadmeMemo );
    itsDoc.ReadmeText( ProjectReadmeMemo->Lines->Text.c_str() );
	itsUpdateFlag--;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmeSaveBitBtnClick(TObject *Sender)
{
	TUpDialog::SaveMyMemo( ProjectReadmeMemo );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ProjectReadmePreviewBitBtnClick(TObject *Sender)
{
    char *		readmetext;
    readmetext = itsDoc.GenerateReadme();
    if	( readmetext ) {
		Application->CreateForm( __classid(TUpReadmePreviewDialog), &UpReadmePreviewDialog );
		UpReadmePreviewDialog->ReadmeMemo->Lines->Text = readmetext;
        delete [] readmetext;
		UpReadmePreviewDialog->ShowModal();
	    UpReadmePreviewDialog->Release();
		UpReadmePreviewDialog = NULL;
    }
}

//---------------------------------------------------------------------------
// EOF: TUpDialogProject.cpp
//---------------------------------------------------------------------------
