//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpDialog.h"
#include "TUpAskDisposalDialog.h"
#include "TUpOpenDialog.h"
#include "TUpSaveDialog.h"
#include "TUpDocProgressDialog.h"
#include "TUpZipProgressDialog.h"
#include "TUpBrowseDirectoryDialog.h"

#include "CPicture.hxx"
#include "CPictureSourceUTX.hxx"

#include "jpeg.hpp"

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ZipComprProgress	( TThreadFunc MyFunc ) {
	unsigned int	thread_id = 0;
	if	( ::BeginThread( NULL, 32768, MyFunc, (void *)&itsDoc, 0, thread_id ) > 0 ) {
		// Then create the dialog
		SLEEP(100);
        if	( itsDoc.ZipProgress().Ready() == false ) {
		   	Application->CreateForm( __classid(TUpZipProgressDialog), &UpZipProgressDialog );
			UpZipProgressDialog->itsDoc = &itsDoc;
			UpZipProgressDialog->ShowModal();
	        Application->OnIdle = MyIdleHandler;
		    UpZipProgressDialog->Release();
			UpZipProgressDialog = NULL;
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::DocumentProgress	( TThreadFunc MyFunc, const char * aTitle ) {
	unsigned int	thread_id = 0;
	if	( ::BeginThread( NULL, 32768, MyFunc, (void *)&itsDoc, 0, thread_id ) > 0 ) {
		// Then create the dialog
		SLEEP(100);
        if	( itsDoc.ProgressDone() == false ) {
		   	Application->CreateForm( __classid(TUpDocProgressDialog), &UpDocProgressDialog );
			UpDocProgressDialog->itsDoc = &itsDoc;
			UpDocProgressDialog->TopMessagePanel->Caption = aTitle;
			UpDocProgressDialog->ShowModal();
	        Application->OnIdle = MyIdleHandler;
		    UpDocProgressDialog->Release();
			UpDocProgressDialog = NULL;
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SaveMyMemo	( TMemo * aM ) {
	char *	filename;
    filename = TUpDialog::SaveFileQuery( "*.txt", "Untitled" );
    if	( filename ) {
		::unlink( filename );
		aM->Lines->SaveToFile( filename );
        delete [] filename;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::LoadMyMemo	( TMemo * aM ) {
	char *	filename;
    filename = TUpDialog::OpenFileQuery( "*.txt" );
    if	( filename ) {
		aM->Lines->Clear();
		aM->Lines->LoadFromFile( filename );
        delete [] filename;
    }
    TUpDialog::Populate( NULL );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SaveMyPicture( TImage * aI ) {
	TJPEGImage *	myjpeg		= NULL;
	char *			imagefile	= NULL;

    imagefile = TUpDialog::SaveFileQuery( "*.jpg;*.bmp;*.ico", "Untitled" );
	if	( imagefile ) {
		::unlink( imagefile );

		try	{
			char	suffix[128];
        	::fnsplit( imagefile, NULL, NULL, NULL, suffix );
	        if		( ! ::stricmp( suffix, ".bmp" ) ) {
	        	aI->Picture->SaveToFile( imagefile );
    	    }
        	else if	( ! ::stricmp( suffix, ".ico" ) ) {
	        	aI->Picture->SaveToFile( imagefile );
	        }
    	    else if	( ! ::stricmp( suffix, ".jpg" ) ) {
            	myjpeg = new TJPEGImage;
                myjpeg->Assign( aI->Picture->Graphic );
                myjpeg->SaveToFile( imagefile );
	        }
		}
	    catch ( ... ) {
	    }
    }
    if	( myjpeg )		delete myjpeg;
	if	( imagefile )	delete [] imagefile;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ShowMyPicture( TScrollBox * aSb, TImage * aI, const char * aFile ) {
	TJPEGImage *	myjpeg;
    myjpeg = NULL;

	try	{
		char	suffix[128];
        ::fnsplit( aFile, NULL, NULL, NULL, suffix );
        if		( ! ::stricmp( suffix, ".bmp" ) ) {
        	aI->Picture->LoadFromFile( aFile );
            aI->Height = aI->Picture->Height;
            aI->Width = aI->Picture->Width;
		    TUpDialog::CenterDisplayImage( aSb, aI );
        }
        else if	( ! ::stricmp( suffix, ".ico" ) ) {
        	aI->Picture->LoadFromFile( aFile );
            aI->Height = aI->Picture->Height;
            aI->Width = aI->Picture->Width;
		    TUpDialog::CenterDisplayImage( aSb, aI );
        }
        else if	( ( ! ::stricmp( suffix, ".jpg" ) ) ||
				  ( ! ::stricmp( suffix, ".jpeg" ) ) ) {
			myjpeg = new TJPEGImage;
            myjpeg->LoadFromFile( aFile );
            aI->Width 	= myjpeg->Width;
            aI->Height	= myjpeg->Height;
			aI->Canvas->Draw( 0, 0, myjpeg );
		    TUpDialog::CenterDisplayImage( aSb, aI );
        }
	}
    catch ( ... ) {
    	aI->Width	= 0;
    	aI->Height	= 0;
	    TUpDialog::CenterDisplayImage( aSb, aI );
    }
	if	( myjpeg ) delete myjpeg;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ShowMyPicture( TScrollBox * aSb, TImage * aI, const CUnTexture * aTx ) {
	try	{
		CPicture			mypicture;
		CPictureSourceUTX	utxsource( aTx );
		mypicture.Load( utxsource );
    	TUpDialog::ShowMyPicture( aSb, aI, mypicture );
    }
    catch ( ... ) {
    	aI->Width	= 0;
    	aI->Height	= 0;
	    TUpDialog::CenterDisplayImage( aSb, aI );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ShowMyPicture( TScrollBox * aSb, TImage * aI, const CPicture & aPx ) {
	Graphics::TBitmap *	mybitmap;
	mybitmap = NULL;
	try	{
    	mybitmap = new Graphics::TBitmap;
        mybitmap->Height = aPx.H();
        mybitmap->Width  = aPx.W();
	    dword_t	x, y;
    	for	( y = 0; y < aPx.H(); y++ ) {
       		for	( x = 0; x < aPx.W(); x++ ) {
           		mybitmap->Canvas->Pixels[x][y] = (TColor)aPx.Pixel(x, y).DwPx();
	        }
    	}
		aI->Picture->Bitmap->Width = aPx.W();
        aI->Picture->Bitmap->Height= aPx.H();
	    aI->Width	= aPx.W();
    	aI->Height	= aPx.H();
		aI->Canvas->Draw( 0, 0, mybitmap );
	}
    catch	( ... ) {
    	aI->Width	= 0;
    	aI->Height	= 0;
    }
	if	( mybitmap ) delete mybitmap;
    TUpDialog::CenterDisplayImage( aSb, aI );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::CenterDisplayImage	( TScrollBox * aSb, TImage * aI ) {
	aI->Top		= aSb->Height / 2 - aI->Height / 2;
    aI->Left	= aSb->Width  / 2 - aI->Width / 2;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::DisplayObjectFlags	( TPanel * aP1, TPanel * aP2, CUnObjectFlags aF ) {
	char	flagstring[128];
	::strcpy( flagstring, aF.Transactional() ? " * " : "   " );
    ::strcat( flagstring, aF.Unreachable() ? " * " : "   " );
    ::strcat( flagstring, aF.Public() ? " * " : "   " );
    ::strcat( flagstring, aF.TagImp() ? " * " : "   " );
    ::strcat( flagstring, aF.TagExp() ? " * " : "   " );
    ::strcat( flagstring, aF.SourceModified() ? " * " : "   " );
    ::strcat( flagstring, aF.TagGarbage() ? " * " : "   " );
    ::strcat( flagstring, aF.NeedLoad() ? " * " : "   " );
    ::strcat( flagstring, aF.HighlightedName() ? " * " : "   " );
    ::strcat( flagstring, aF.EliminateObject() ? " * " : "   " );
    ::strcat( flagstring, aF.InSingularFunc() ? " * " : "   " );
    ::strcat( flagstring, aF.RemappedName() ? " * " : "   " );
    ::strcat( flagstring, aF.Suppress() ? " * " : "   " );
    ::strcat( flagstring, aF.StateChanged() ? " * " : "   " );
    ::strcat( flagstring, aF.InEndState() ? " * " : "   " );
    ::strcat( flagstring, aF.Transient() ? " * " : "   " );
    ::strcat( flagstring, aF.PreLoading() ? " * " : "   " );
	aP1->Caption = flagstring;

    ::strcpy( flagstring, aF.LoadForClient() ? " * " : "   " );
    ::strcat( flagstring, aF.LoadForServer() ? " * " : "   " );
    ::strcat( flagstring, aF.LoadForEdit() ? " * " : "   " );
    ::strcat( flagstring, aF.Standalone() ? " * " : "   " );
    ::strcat( flagstring, aF.NotForClient() ? " * " : "   " );
    ::strcat( flagstring, aF.NotForServer() ? " * " : "   " );
    ::strcat( flagstring, aF.NotForEdit() ? " * " : "   " );
    ::strcat( flagstring, aF.Destroyed() ? " * " : "   " );
    ::strcat( flagstring, aF.NeedPostLoad() ? " * " : "   " );
    ::strcat( flagstring, aF.HasStack() ? " * " : "   " );
    ::strcat( flagstring, aF.Native() ? " * " : "   " );
    ::strcat( flagstring, aF.Marked() ? " * " : "   " );
    ::strcat( flagstring, aF.ErrorShutdown() ? " * " : "   " );
    ::strcat( flagstring, aF.DebugPostLoad() ? " * " : "   " );
    ::strcat( flagstring, aF.DebugSerialize() ? " * " : "   " );
    ::strcat( flagstring, aF.DebugDestroy() ? " * " : "   " );
	aP2->Caption = flagstring;
}

//---------------------------------------------------------------------------
CUpInput __fastcall TUpDialog::GetInputItem	( void ) {
	CUpInput	result;
	if	( FilesCheckListBox->ItemIndex >= 0 ) {
	    result = itsDoc.InputListItem( FilesCheckListBox->Items->Strings[FilesCheckListBox->ItemIndex].c_str() );
	}
	return	result;
}

//---------------------------------------------------------------------------
bool __fastcall TUpDialog::CanDisposeChanges( const char * aMessage ) {
	bool	result;

	Application->CreateForm( __classid(TUpAskDisposalDialog), &UpAskDisposalDialog );
    UpAskDisposalDialog->MessagePanel->Caption = aMessage;
	result = UpAskDisposalDialog->ShowModal() == mrOk;
    UpAskDisposalDialog->Release();
	UpAskDisposalDialog = NULL;
	return	result;
}

//---------------------------------------------------------------------------
char * __fastcall TUpDialog::OpenFileQuery( const char * aMask ) {
	char *	myfile = NULL;

	Application->CreateForm( __classid(TUpOpenDialog), &UpOpenDialog );
    UpOpenDialog->FileListBox->Mask = aMask;
	if	( UpOpenDialog->ShowModal() == mrOk ) {
    	myfile = ::my_private_strdup( UpOpenDialog->FileNamePanel->Caption.c_str() );
    }
    UpOpenDialog->Release();
	UpOpenDialog = NULL;
	return	myfile;
}

//---------------------------------------------------------------------------
char * __fastcall TUpDialog::SaveFileQuery( const char * aMask, const char * aDefaultFileName ) {
	char *	myfile = NULL;

	Application->CreateForm( __classid(TUpSaveDialog), &UpSaveDialog );
    UpSaveDialog->FileListBox->Mask = aMask;
	UpSaveDialog->DefaultName = aDefaultFileName;
	if	( UpSaveDialog->ShowModal() == mrOk ) {
    	myfile = ::my_private_strdup( UpSaveDialog->FileNameEdit->Text.c_str() );
    }
    UpSaveDialog->Release();
	UpSaveDialog = NULL;
	return	myfile;
}

//---------------------------------------------------------------------------
char * __fastcall TUpDialog::DirectoryQuery	( const char * aTitle ) {
	char *	myfile = NULL;

	Application->CreateForm( __classid(TUpBrowseDirectoryDialog), &UpBrowseDirectoryDialog );
    UpBrowseDirectoryDialog->TitlePanel->Caption = aTitle;
	if	( UpBrowseDirectoryDialog->ShowModal() == mrOk ) {
    	myfile = ::my_private_strdup( UpBrowseDirectoryDialog->DirectoryNamePanel->Caption.c_str() );
    }

    UpBrowseDirectoryDialog->Release();
	UpBrowseDirectoryDialog = NULL;
	return	myfile;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TEdit * aEdit, bool aEnable ) {
	itsUpdateFlag++;
	aEdit->Enabled	= aEnable;
    aEdit->Color	= aEnable ? clWindow : clBtnFace;
    if	( ! aEnable ) aEdit->Text = "";
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TMaskEdit * aEdit, bool aEnable ) {
	itsUpdateFlag++;
	aEdit->Enabled	= aEnable;
    aEdit->Color	= aEnable ? clWindow : clBtnFace;
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TComboBox * aCombo, bool aEnable ) {
	itsUpdateFlag++;
	aCombo->Enabled	= aEnable;
    aCombo->Color	= aEnable ? clWindow : clBtnFace;
    if	( aCombo->ItemIndex < 0 )	aCombo->ItemIndex = 0;
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TMemo * aMemo, bool aEnable ) {
	itsUpdateFlag++;
	aMemo->Enabled	= aEnable;
    aMemo->Color	= aEnable ? clWindow : clBtnFace;
    if	( ! aEnable ) aMemo->Lines->Text = "";
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TCheckBox * aCbx, bool aEnable ) {
	itsUpdateFlag++;
	aCbx->Enabled	= aEnable;
    if	( ! aEnable ) aCbx->Checked = false;
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TCheckListBox * aCbx, bool aEnable ) {
	itsUpdateFlag++;
	aCbx->Enabled	= aEnable;
    aCbx->Color		= aEnable ? clWindow : clBtnFace;
    if	( ! aEnable ) {
    	aCbx->Items->Clear();
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TListBox * aCbx, bool aEnable ) {
	itsUpdateFlag++;
	aCbx->Enabled	= aEnable;
    aCbx->Color		= aEnable ? clWindow : clBtnFace;
    if	( ! aEnable ) {
    	aCbx->Items->Clear();
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TPageControl * aPc, bool aEnable ) {
	aPc->Enabled	= aEnable;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TPanel * aPc, bool aEnable ) {
	aPc->Enabled	= aEnable;
    if	( ! aEnable ) aPc->Caption = "";
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetControlEnable( TRadioGroup * aPc, bool aEnable ) {
	aPc->Enabled	= aEnable;
	if	( aPc->ItemIndex < 0 ) {
    	aPc->ItemIndex = 0;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetPanelValue( TPanel * aP, bool aV ) {
	aP->Caption = aV ? "true" : "false";
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetPanelValue( TPanel * aP, dword_t aV ) {
	char	numbuf[32];
    ::sprintf( numbuf, "%d", aV );
	aP->Caption = numbuf;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetPanelValue( TPanel * aP, word_t aV ) {
	char	numbuf[32];
    ::sprintf( numbuf, "%d", aV );
	aP->Caption = numbuf;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetPanelValueHex( TPanel * aP, dword_t aV ) {
	char	numbuf[32];
    ::sprintf( numbuf, "%08X", aV );
	aP->Caption = numbuf;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetPanelValue( TPanel * aP, const char * aV ) {
	aP->Caption = aV;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::SetPanelValue( TPanel * aP, time_t aV ) {
	char	mytime[32];
    ::strcpy( mytime, ::ctime( &aV ) );
    ::my_strfix( mytime );
    aP->Caption = mytime;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ManageCheckBoxList	( TCheckListBox * aCbx, const void * aList ) {
	const CUpString_l *	list;
    CUpString_lci		loop;
    int					item;

    list = (const CUpString_l *)aList;

	item = 0;
    loop = list->begin();

    // Update the list as long as there are items in both
    while	( ( item < aCbx->Items->Count ) && ( loop != list->end() ) ) {
    	if	( ::strcmp( aCbx->Items->Strings[item].c_str(), (*loop).ListName() ) ) {
			aCbx->Items->Strings[item] = (*loop).ListName();
        }
    	if	( aCbx->Checked[item] != (*loop).ListSelect() ) {
        	aCbx->Checked[item] = (*loop).ListSelect();
        }
        loop++;
        item++;
    }

	// Insert to the list as long as we have additional data
    while	( loop != list->end() ) {
    	aCbx->Items->Add( (*loop).ListName() );
       	aCbx->Checked[item] = (*loop).ListSelect();
        loop++;
        item++;
    }

	// Remove items as long as possible
    while	( item < aCbx->Items->Count ) {
    	aCbx->Items->Delete( item );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ManageListBox	( TListBox * aCbx, const void * aList ) {
	const CUpString_l *	list;
    CUpString_lci		loop;
    int					item;

    list = (const CUpString_l *)aList;

	item = 0;
    loop = list->begin();

    // Update the list as long as there are items in both
    while	( ( item < aCbx->Items->Count ) && ( loop != list->end() ) ) {
    	if	( ::strcmp( aCbx->Items->Strings[item].c_str(), (*loop).ListName() ) ) {
			aCbx->Items->Strings[item] = (*loop).ListName();
        }
        loop++;
        item++;
    }

	// Insert to the list as long as we have additional data
    while	( loop != list->end() ) {
    	aCbx->Items->Add( (*loop).ListName() );
        loop++;
        item++;
    }

	// Remove items as long as possible
    while	( item < aCbx->Items->Count ) {
    	aCbx->Items->Delete( item );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ChkClkCheckBoxList	( TCheckListBox * aCbx, void * aList ) {
	CUpString_l *		list;
    CUpString_li		loop;

    if	( aCbx->ItemIndex < 0 )	return;

    list = (CUpString_l *)aList;
    for	( loop = list->begin(); loop != list->end(); loop++ ) {
    	if	( ! ::strcmp( aCbx->Items->Strings[aCbx->ItemIndex].c_str(), (*loop).ListName() ) ) {
			if	( (*loop).ListSelect() != aCbx->Checked[aCbx->ItemIndex] ) {
            	(*loop).ListSelect( aCbx->Checked[aCbx->ItemIndex] );
	            itsDoc.Dirty( true );
            }
            break;
        }
    }
}

// --------------------------------------------------------------------
CFtpFile_l __fastcall	TUpDialog::LocalMirrorFileList	( void ) {
	TSearchRec	sr;
	struct stat mystat;
	char		wild	[512];
	char		myfile	[512];
	CFtpFile_l	result;
	CFtpFile	myitem;

	::sprintf(	wild, "%s\\*.*", itsDoc.FtpMirLocalRoot() );

    if	( FindFirst( wild, faAnyFile, sr ) == 0 ) {
		do {
			if	( sr.Name == "." )	continue;
			if	( sr.Name == ".." )	continue;
			::sprintf( myfile, "%s\\%s", itsDoc.FtpMirLocalRoot(), sr.Name.c_str() );
			if	( ::stat( myfile, &mystat ) != 0 )	continue;
            if	( mystat.st_mode & S_IFREG ) {
				myitem.Name( sr.Name.c_str() );
				myitem.Time( mystat.st_mtime );
                myitem.Size( mystat.st_size );
                myitem.Dirf( false );
                myitem.Cmnd( 1 );
				result.push_back( myitem );
			}
        }	while ( FindNext( sr ) == 0 );
		FindClose( sr );
	}

    return	result;
}

// --------------------------------------------------------------------
CFtpFile_l __fastcall	TUpDialog::CreateMirrorList( const CFtpFile_l & aSource, const CFtpFile_l & aTarget, bool aDownload ) {
	CFtpFile_l		result;
    CFtpFile		myitem;
    CFtpFile_lci	sl;
    CFtpFile_lci	tl;

    // Scan files that are missing from the target (do transfers)
    if	( itsDoc.FtpMirAdd() ) {
	    for	( sl = aSource.begin(); sl != aSource.end(); sl++ ) {
    		if	( (*sl).Dirf() )	continue;
			for	( tl = aTarget.begin(); tl != aTarget.end(); tl++ ) {
		    	if	( (*tl).Dirf() )	continue;
            	if	( !::strcmp( (*sl).Name(), (*tl).Name() ) ) break;
    	    }
			if	( tl == aTarget.end() ) {
				myitem = *sl;
	            if	( aDownload )	myitem.Cmnd( 'D' );
    	        else				myitem.Cmnd( 'U' );
        	    result.push_back( myitem );
            }
        }
    }

	// Scan files that are in both lists but should be updated
    if	( itsDoc.FtpMirMod() ) {
		for	( tl = aTarget.begin(); tl != aTarget.end(); tl++ ) {
    		if	( (*tl).Dirf() )	continue;
		    for	( sl = aSource.begin(); sl != aSource.end(); sl++ ) {
    	    	if	( (*sl).Dirf() )	continue;
            	if	( !::strcmp( (*sl).Name(), (*tl).Name() ) ) break;
    	    }
			if	( sl != aSource.end() ) {
				if	( (*sl).Size() == (*tl).Size() ) {
                	if	( (*tl).Time() >= (*sl).Time() ) {
                    	continue;
                    }
                }

				myitem = *sl;
	            if	( aDownload )	myitem.Cmnd( 'D' );
    	        else				myitem.Cmnd( 'U' );
        	    result.push_back( myitem );
            }
        }
	}

    // Scan files that are missing from the source (do deletions)
    if	( itsDoc.FtpMirDel() ) {
		for	( tl = aTarget.begin(); tl != aTarget.end(); tl++ ) {
    		if	( (*tl).Dirf() )	continue;
		    for	( sl = aSource.begin(); sl != aSource.end(); sl++ ) {
    	    	if	( (*sl).Dirf() )	continue;
            	if	( !::strcmp( (*sl).Name(), (*tl).Name() ) ) break;
    	    }
			if	( sl == aSource.end() ) {
				myitem = *tl;
	            if	( aDownload )	myitem.Cmnd( 'X' );
    	        else				myitem.Cmnd( 'R' );
        	    result.push_back( myitem );
            }
        }
	}

    return	result;
}

// --------------------------------------------------------------------
// EOF:	TUpDIalogUtils.cpp
// --------------------------------------------------------------------
