//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpMirrorDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TUpMirrorDialog *UpMirrorDialog = NULL;
//---------------------------------------------------------------------------
__fastcall TUpMirrorDialog::TUpMirrorDialog(TComponent* Owner) : TForm(Owner) {
    ListingDone	= false;
    DoMirroring = false;
    ::memset( LocalDirectory, 0, sizeof( LocalDirectory ) );
    MirrorButton->Enabled = false;
    FtpClient	= NULL;
    CurrentIndex = -1;
	Application->OnIdle = MyIdleHandler;
}

//---------------------------------------------------------------------------
void __fastcall TUpMirrorDialog::MyIdleHandler (TObject * Sender, bool & Done ) {
   	char	myline	[1024];
	Done = false;
    if	( ListingDone == false ) {
        MirrorOperationListBox->Items->Clear();
    	for	( CFtpFile_li loop = FtpList.begin(); loop != FtpList.end(); loop++ ) {
			switch	( (*loop).Cmnd() ) {
            	case	'D':	::strcpy( myline, "Download " );	break;
            	case	'U':	::strcpy( myline, "Upload   " );	break;
            	case	'R':	::strcpy( myline, "Remove   " );	break;
            	case	'X':	::strcpy( myline, "Delete   " );	break;
            }
			if	( ( (*loop).Cmnd() == 'X' ) || ( (*loop).Cmnd() == 'U' ) ) {
            	::strcat( myline, LocalDirectory );
                ::strcat( myline, "\\" );
            }
            ::strcat( myline, (*loop).Name() );
	        MirrorOperationListBox->Items->Add( myline );
        }
        ListingDone = true;
        return;
    }

    if	( FtpClient == NULL ) {
    	MirrorButton->Enabled = false;
        return;
    }

    if	(  MirrorMessagePanel->Caption != FtpClient->Message() ) {
    	MirrorMessagePanel->Caption = FtpClient->Message();
    }

	// FTP client aborting ???
    if	( FtpClient->State() == ftp_state_offline ) {
		ModalResult = mrCancel;
        SLEEP(100);
        return;
    }

    // FTP Client in the middle of something ???
    if	( FtpClient->State() != ftp_state_online ) {
	    MirrorOperationListBox->ItemIndex = CurrentIndex;
        SLEEP(100);
        return;
    }

    // Has the user commanded the mirroring to start ?
    if	( ! DoMirroring ) {
    	MirrorButton->Enabled = true;
        SLEEP(100);
        return;
    }

    // First time in ?
    if		( CurrentIndex < 0 ) {
    	CurrentIndex++;
        FtpLoop = FtpList.begin();
    }
    else if	( FtpLoop == FtpList.end() ) {
		ModalResult = mrOk;
        return;
    }
    else {
    	CurrentIndex++;
        FtpLoop++;
    }

	// Start up some process
	switch	( (*FtpLoop).Cmnd() ) {
		case	'D':	::sprintf( myline, "%s\\%s", LocalDirectory, (*FtpLoop).Name() );
        				FtpClient->Download( myline );
                        break;

		case	'U':	::sprintf( myline, "%s\\%s", LocalDirectory, (*FtpLoop).Name() );
        				FtpClient->Upload( myline );
                        break;

		case	'R':	FtpClient->Remove( (*FtpLoop).Name() );
        				break;

		case	'X':	::sprintf( myline, "%s\\%s", LocalDirectory, (*FtpLoop).Name() );
        				::unlink( myline );
                        break;
	}
}

//---------------------------------------------------------------------------
void __fastcall TUpMirrorDialog::CancelButtonClick(TObject *Sender) {
	ModalResult = mrCancel;
}

//---------------------------------------------------------------------------
void __fastcall TUpMirrorDialog::MirrorButtonClick(TObject *Sender) {
	DoMirroring = true;
    MirrorButton->Enabled = false;
}

//---------------------------------------------------------------------------
