//---------------------------------------------------------------------------
#include <vcl.h>
#include <dir.h>
#pragma hdrstop

#include	"TUpSaveDialog.h"
#include	"TUpAskDisposalDialog.h"
#include    "CUpDoc.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TUpSaveDialog *UpSaveDialog = NULL;
//---------------------------------------------------------------------------
__fastcall TUpSaveDialog::TUpSaveDialog(TComponent* Owner)
	: TForm(Owner)
{
	OkButton->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TUpSaveDialog::FileListBoxChange(TObject *Sender)
{
	char	pathname[512];

	if		( FileListBox->ItemIndex < 0 ) {
    	::strcpy( pathname, FileListBox->Directory.c_str() );
        ::strcat( pathname, "\\" );
        if	( DefaultName == "" ) {
        	DefaultName = "Untitled";
        }
        if	( DefaultSuffix == "" ) {
        	char	suffix[128];
	        ::strcpy( suffix, FileListBox->Mask.c_str() );
	        if	( ::strchr( suffix, ',' ) ) *::strchr( suffix, ',' ) = 0;
	        if	( ::strchr( suffix, ';' ) ) *::strchr( suffix, ';' ) = 0;
    	    if	( ::strchr( suffix, '*' ) ) {
        		::strcpy( ::strchr( suffix, '*' ), ::strchr( suffix, '*' ) + 1 );
	        }
    	    ::my_strfix( suffix );
            DefaultSuffix = suffix;
        }
		::strcat( pathname, DefaultName.Value() );
		::strcat( pathname, DefaultSuffix.Value() );
        FileNameEdit->Text = pathname;
    }
    else {
		FileNameEdit->Text = FileListBox->FileName;
    }
}
//---------------------------------------------------------------------------
void __fastcall TUpSaveDialog::FileNameEditChange(TObject *Sender)
{
	char	filename[512];
    char	suffix	[128];
    char	mask	[256];
    char *	m;
    char	ch;

	*suffix 	= 0;
	*filename	= 0;
    ::fnsplit( FileNameEdit->Text.c_str(), NULL, NULL, filename, suffix );
	::memset( mask, 0, sizeof( mask ) );
    ::strcpy( mask, FileListBox->Mask.c_str() );
    MaskListPanel->Caption = mask;

    if		( *filename == 0 ) {
    	OkButton->Enabled = false;
    }
	else if	( *mask == 0 ) {
    	OkButton->Enabled = true;
    }
    else if	( ::strlen( suffix ) < 2 ) {
		OkButton->Enabled = false;
    }
    else if	( ::strstr( MaskListPanel->Caption.c_str(), suffix ) ) {
    	// We try to ensure that the suffix is in our list
    	m = ::strstr( mask, suffix );
        while	( m ) {
        	ch = m[ ::strlen( suffix ) ];
        	if	( ch == ',' )	break;
            if	( ch == ';' )	break;
			if	( ( ch >= 0 ) && ( ch <= ' ' ) )	break;
			m = ::strstr( m + 1, suffix );
		}
    	OkButton->Enabled = (m != NULL);
        if	( m != NULL ) {
        	DefaultSuffix = suffix;
        }
        DefaultName = filename;
    }
    else {
		OkButton->Enabled = false;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpSaveDialog::OkButtonClick(TObject *Sender)
{	// Checking for overwriting an existing file !
	struct stat	mystat;
    if	( ::stat( FileNameEdit->Text.c_str(), &mystat ) == 0 ) {
		Application->CreateForm( __classid(TUpAskDisposalDialog), &UpAskDisposalDialog );
	    UpAskDisposalDialog->MessagePanel->Caption = "Overwrite the file anyway ?";
		if	( UpAskDisposalDialog->ShowModal() == mrOk ) {
			ModalResult = mrOk;
        }
    	UpAskDisposalDialog->Release();
		UpAskDisposalDialog = NULL;
    }
    else {
		ModalResult = mrOk;
    }
}

//---------------------------------------------------------------------------

