// --------------------------------------------------------------------
// CUtxDoc.h
// Whatis:  File details
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUtxDoc_h
#define CUtxDoc_h
#include	"CCpuMutex.hxx"
#include	"CUtxFile.h"

// --------------------------------------------------------------------
class CUtxDoc {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUtxDoc		();
	~CUtxDoc	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator invalid
	// ----------------------------------------------------------------
	CUtxDoc					( const CUtxDoc & );
	CUtxDoc & operator =	( const CUtxDoc & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
    void				Init			( const char * );
    CUtxFile &			Item			( int );
	void				Propagate		( const CUtxFile & );
    void				Lock			( void );
    void				Unlock			( void );
    bool				CanCompress		( void );
	void				CompressAll		( void );
    void				CompressCan		( void );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    char				Drive			( void ) const;
    const CUtxFile_l &	FileList		( void ) const;
    bool				CompressDon		( void ) const;
    const char *		CompressMsg		( void ) const;
    const char *		CompressFil		( void ) const;
    int					CompressMax		( void ) const;
    int					CompressPos		( void ) const;
    const char *		Warning			( void ) const;

	// ----------------------------------------------------------------
    void				Drive		( char );
    void				TextureFile	( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void				CreateCompressDirs	( void );
    void				RemoveCompressDirs	( void );
    void				CreateCompressImgs	( void );
    void				RemoveCompressImgs	( void );
    void				CreateCompressClaf	( void );
    void				RemoveCompressClaf	( void );
    void				CreateCompressInif	( void );
    void				RemoveCompressInif	( void );
    void				CreateCompressTexf	( void );
    void				CreateCompressMove	( void );
    void				DxtCompress			( const CUtxFile &, const char * );
    void				NonCompress			( const CUtxFile &, const char * );
    void				Compile				( const char *, const char * );
	void				FillFileList		( void );
    void				DetectSystem		( void );
    void				Free				( void );
    void				Cleanup				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    char			itsDrive;
    char			itsNvExe	[1024];
    char			itsUtRoot	[1024];
    CUtxFile_l		itsFileList;
    char *			itsTextureFile;
    bool			itsCompressDon;
    const char *	itsCompressMsg;
    const char *	itsCompressFil;
    int				itsCompressMax;
    int				itsCompressPos;
	const char *	itsWarning;
    CCpuMutex		itsMutex;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------

#endif
// --------------------------------------------------------------------
// EOF:	CUtxDoc.h
// --------------------------------------------------------------------
