// --------------------------------------------------------------------
// CUtxFile.cpp
// Whatis:  File details
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUtxFile.h"

// --------------------------------------------------------------------
CUtxFile::CUtxFile	() {
	CUtxFile::Cleanup();
}

// --------------------------------------------------------------------
CUtxFile::~CUtxFile	() {
	CUtxFile::Free();
}

// --------------------------------------------------------------------
CUtxFile::CUtxFile				( const CUtxFile & aC ) {
	CUtxFile::Cleanup();
    CUtxFile::MipMaps		( aC.MipMaps() );
    CUtxFile::Masked		( aC.Masked() );
    CUtxFile::Alpha			( aC.Alpha() );
    CUtxFile::Group			( aC.Group() );
    CUtxFile::Name			( aC.Name() );
	CUtxFile::Directory		( aC.Directory() );
    CUtxFile::File			( aC.File() );
    CUtxFile::Select	   	( aC.Select() );
    CUtxFile::TextureType	( aC.TextureType() );
    itsDxt.Options( aC.DxtC().OptionsC() );
}

// --------------------------------------------------------------------
CUtxFile & CUtxFile::operator =	( const CUtxFile & aC ) {
	CUtxFile::Free();
    CUtxFile::MipMaps		( aC.MipMaps() );
    CUtxFile::Masked		( aC.Masked() );
    CUtxFile::Alpha			( aC.Alpha() );
    CUtxFile::Group			( aC.Group() );
    CUtxFile::Name			( aC.Name() );
	CUtxFile::Directory		( aC.Directory() );
    CUtxFile::File			( aC.File() );
    CUtxFile::Select	   	( aC.Select() );
    CUtxFile::TextureType	( aC.TextureType() );
    itsDxt.Options( aC.DxtC().OptionsC() );
    return *this;
}

// --------------------------------------------------------------------
void	CUtxFile::Propagate	( const CUtxFile & aC ) {
	if	( CUtxFile::Directory() )	return;
    CUtxFile::MipMaps		( aC.MipMaps() );
    CUtxFile::Masked		( aC.Masked() );
    CUtxFile::Alpha			( aC.Alpha() );
    CUtxFile::Group			( aC.Group() );
    CUtxFile::TextureType	( aC.TextureType() );
    itsDxt.Options( aC.DxtC().OptionsC() );
}

// --------------------------------------------------------------------
const CDxt &	CUtxFile::DxtC	( void ) const {
	return itsDxt;
}

// --------------------------------------------------------------------
CDxt &	CUtxFile::Dxt	( void ) {
	return itsDxt;
}

// --------------------------------------------------------------------
int				CUtxFile::TextureType	( void ) const { return itsTextureType; }
bool			CUtxFile::MipMaps		( void ) const { return itsMipMaps; }
bool			CUtxFile::Masked		( void ) const { return itsMasked; }
bool			CUtxFile::Alpha			( void ) const { return itsAlpha; }
const char *	CUtxFile::Group			( void ) const { return itsGroup ? itsGroup : ""; }
const char *	CUtxFile::Name			( void ) const { return itsName ? itsName : ""; }
bool			CUtxFile::Directory		( void ) const { return itsDirectory; }
const char *	CUtxFile::File			( void ) const { return itsFile ? itsFile : ""; }
bool			CUtxFile::Select		( void ) const { return itsSelect; }

// --------------------------------------------------------------------
void			CUtxFile::TextureType	( int aV )			{
	char	mysuff [64];

    ::fnsplit( itsFile, NULL, NULL, NULL, mysuff );
    ::strlwr( mysuff );

    if		( ! ::strcmp( mysuff, ".pcx" ) ) {
    	aV = 0;
    }

    else if	( aV == 0 ) {
    	if	( ! ::strstr( ".bmp.pcx.tga", mysuff ) ) {
        	aV = 1;
        }
    }

    else if	( aV > 3 ) {
    	aV = 1;
    }

	itsTextureType = aV;
}

void			CUtxFile::MipMaps		( bool aV )         { itsMipMaps = aV; }
void			CUtxFile::Masked		( bool aV )         { itsMasked = aV; }
void			CUtxFile::Alpha			( bool aV )         { itsAlpha = aV; }
void			CUtxFile::Group			( const char * aV ) {
	if	( itsGroup ) delete [] itsGroup;
    itsGroup = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CUtxFile::Name			( const char * aV ) {
	int		i;
	if	( itsName ) delete [] itsName;
    itsName = ::my_private_strdup( aV );

    if	( itsName ) {
		for	( i = 0; itsName[i]; i++ ) {
        	if	( ::strchr( "0123456789", itsName[i] ) )					continue;
        	if	( ::strchr( "abcdefghijklmnopqrstuvwxyz", itsName[i] ) )	continue;
        	if	( ::strchr( "ABCDEFGHIJKLMNOPQRSTUVWXYZ", itsName[i] ) )	continue;
			switch	( itsName[i] ) {
            	case	'':	itsName[i] = 'U';	break;
            	case	'':	itsName[i] = 'u';	break;
            	case	'':	itsName[i] = 'o';	break;
            	case	'':	itsName[i] = 'O';	break;
            	case	'':	itsName[i] = 'A';	break;
            	case	'':	itsName[i] = 'a';	break;
            	case	'^':	itsName[i] = 'a';	break;
            	case	'+':	itsName[i] = 'p';	break;
                case	'-':	itsName[i] = 'm';	break;
                case	'*':	itsName[i] = 'x';	break;
                case	'/':	itsName[i] = 'i';	break;
				default:		itsName[i] = '_';	break;
            }
        }
    }
}

// --------------------------------------------------------------------
void			CUtxFile::Directory		( bool aV )         { itsDirectory = aV; }
void			CUtxFile::File			( const char * aV ) {
	if	( itsFile ) delete [] itsFile;
    itsFile = ::my_private_strdup( aV );
}

void			CUtxFile::Select		( bool aV )         { itsSelect = aV; }

// --------------------------------------------------------------------
void	CUtxFile::Free		( void ) {
	if	( itsGroup )	delete [] itsGroup;
	if	( itsName )		delete [] itsName;
	if	( itsFile )		delete [] itsFile;
	CUtxFile::Cleanup();
}

// --------------------------------------------------------------------
void	CUtxFile::Cleanup	( void ) {
    itsTextureType	= 1;
    itsMipMaps		= false;
    itsMasked		= false;
    itsAlpha		= false;
    itsGroup		= NULL;
    itsName			= NULL;
	itsDirectory	= false;
    itsFile			= NULL;
    itsSelect		= false;
}

// --------------------------------------------------------------------
// EOF:	CUtxFile.cpp
// --------------------------------------------------------------------
