//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TMainDialog.h"
#include "TProgressDialog.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainDialog *MainDialog;

//---------------------------------------------------------------------------
// local:	Thread for creating the package
//---------------------------------------------------------------------------
static int	__fastcall	CompressionThread( void * aDoc ) {
	CUtxDoc *	mydoc	= (CUtxDoc *)aDoc;

	try	{
	    mydoc->CompressAll();
    }
    catch	( ... ) {
    }
    mydoc->CompressCan();
    return	0;
}

//---------------------------------------------------------------------------
__fastcall TMainDialog::TMainDialog(TComponent* Owner) : TForm(Owner) {
	itsUpdateFlag	= 0;

	try	{
	    itsDoc.Init( Application->ExeName.c_str() );
    }
    catch	( ... ) {
		Application->MessageBox( 	"Aborting the application",
                                    "Needed installation not found",
                                    MB_OK );
		Application->Terminate();
    }
    TMainDialog::Populate();
	DxtPageControl->ActivePage = DxtPageControl->Pages[1];
	DxtPageControl->ActivePage = DxtPageControl->Pages[0];
	DxtPageControl->Pages[0]->Visible = false;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable( TCheckBox * aCbx, bool aEnable ) {
	aCbx->Enabled	= aEnable;
    if	( ! aEnable ) aCbx->Checked = false;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable( TComboBox * aCombo, bool aEnable ) {
	aCombo->Enabled	= aEnable;
    aCombo->Color	= aEnable ? clWindow : clBtnFace;
    if	( aEnable ) {
	    if	( aCombo->ItemIndex < 0 )	aCombo->ItemIndex = 0;
    }
    else {
		aCombo->ItemIndex = -1;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable( TRadioGroup * aRadio, bool aEnable ) {
	aRadio->Enabled	= aEnable;
    if	( aEnable ) {
	    if	( aRadio->ItemIndex < 0 )	aRadio->ItemIndex = 0;
    }
    else {
		aRadio->ItemIndex = -1;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable( TEdit * aEdit, bool aEnable ) {
	aEdit->Enabled	= aEnable;
    aEdit->Color	= aEnable ? clWindow : clBtnFace;
    if	( ! aEnable )	aEdit->Text = "";
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SetControlEnable( TTrackBar * aTbar, bool aEnable ) {
	aTbar->Enabled	= aEnable;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::Populate( void ) {
	CUtxFile	item;

	// Populate the dialog
	itsUpdateFlag++;
    if	( ! itsDoc.CanCompress() ) {
		WarningPanel->Color		= clYellow;
        WarningPanel->Caption	= itsDoc.Warning();
	    ConvertButton->Enabled	= false;
    }
    else {
		WarningPanel->Color		= clBtnFace;
        WarningPanel->Caption	= "";
	    ConvertButton->Enabled	= true;
    }
    DriveComboBox->Drive = (char)(itsDoc.Drive() + 'A');
    if	( FileListCheckListBox->Items->Count == 0 ) {
		char			myfile[1024];
    	char			mycwd	[1024];
		CUtxFile_lci	loop;

		::getcwd( mycwd, sizeof( mycwd ) - 1 );
        for	( loop = itsDoc.FileList().begin(); loop != itsDoc.FileList().end(); loop++ ) {
        	if		( (*loop).Directory() ) {
            	::sprintf( myfile, "<%s>", (*loop).File() );
            }
            else {
            	::strcpy( myfile, (*loop).File() );
            }
            FileListCheckListBox->Items->Add( myfile );
        }
        FileListCheckListBox->ItemIndex = -1;
    }

    bool	doupdate = false;
    if	( FileListCheckListBox->ItemIndex >= 0 ) {
		item = itsDoc.Item( FileListCheckListBox->ItemIndex );
		if	( item.Directory() == false )	doupdate = true;
    }
    ApplyToAllButton->Enabled = doupdate;

    if	( doupdate ) {
		TMainDialog::SetControlEnable( CompressionRadioGroup, true );
        TMainDialog::SetControlEnable( MipMapsCheckBox      , true );
        TMainDialog::SetControlEnable( MaskedCheckBox       , true );
        TMainDialog::SetControlEnable( AlphaCheckBox        , true );
        TMainDialog::SetControlEnable( GroupEdit            , true );
        TMainDialog::SetControlEnable( NameEdit             , true );

		CompressionRadioGroup->ItemIndex= item.TextureType();
        MipMapsCheckBox->Checked        = item.MipMaps();
        MaskedCheckBox->Checked         = item.Masked();
        AlphaCheckBox->Checked          = item.Alpha();
        GroupEdit->Text                 = item.Group();
        NameEdit->Text                  = item.Name();
    }
    else {
		TMainDialog::SetControlEnable( CompressionRadioGroup, false );
        TMainDialog::SetControlEnable( MipMapsCheckBox      , false );
        TMainDialog::SetControlEnable( MaskedCheckBox       , false );
        TMainDialog::SetControlEnable( AlphaCheckBox        , false );
        TMainDialog::SetControlEnable( GroupEdit            , false );
        TMainDialog::SetControlEnable( NameEdit             , false );
    }

    TMainDialog::DxtPageControlChange( NULL );
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
CompressionOptions * __fastcall TMainDialog::DxtOptions( void ) {
	if	( FileListCheckListBox->ItemIndex < 0 )									return	NULL;
	if	( itsDoc.Item( FileListCheckListBox->ItemIndex ).Directory() )			return NULL;
	if	( itsDoc.Item( FileListCheckListBox->ItemIndex ).TextureType() == 0 )	return NULL;
    return itsDoc.Item( FileListCheckListBox->ItemIndex ).Dxt().Options();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::DxtPageControlChange(TObject *Sender) {
	itsUpdateFlag++;
    if	( TMainDialog::DxtOptions() ) {
    	DxtcSettingsGroupBox->Enabled	= true;
        DxtPageControl->Enabled			= true;
        for	( int i = 0; i < DxtPageControl->PageCount; i++ ) {
        	DxtPageControl->Pages[i]->Visible = true;
        }
    }
    else {
    	DxtcSettingsGroupBox->Enabled	= false;
        DxtPageControl->Enabled			= false;
        for	( int i = 0; i < DxtPageControl->PageCount; i++ ) {
        	DxtPageControl->Pages[i]->Visible = false;
        }
    }

	if		( DxtPageControl->ActivePage == DxtPageControl->Pages[0] ) {
   		TMainDialog::PopulateDxtMips();
    }
	else if	( DxtPageControl->ActivePage == DxtPageControl->Pages[1] ) {
   		TMainDialog::PopulateDxtFade();
    }
	else if	( DxtPageControl->ActivePage == DxtPageControl->Pages[2] ) {
   		TMainDialog::PopulateDxtSharp();
    }
	else if	( DxtPageControl->ActivePage == DxtPageControl->Pages[3] ) {
   		TMainDialog::PopulateDxtScale();
    }
	else if	( DxtPageControl->ActivePage == DxtPageControl->Pages[4] ) {
   		TMainDialog::PopulateDxtBorder();
    }
	else if	( DxtPageControl->ActivePage == DxtPageControl->Pages[5] ) {
    	TMainDialog::PopulateDxtOther();
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateDxtMips	( void ) {
	CompressionOptions * opt = TMainDialog::DxtOptions();
	itsUpdateFlag++;
    if	( opt ) {
		TMainDialog::SetControlEnable( MipTypeComboBox,		true );
        TMainDialog::SetControlEnable( MipFilterComboBox,	true );
        TMainDialog::SetControlEnable( MipNumberEdit,		true );
        TMainDialog::SetControlEnable( MipNormCheckBox,		true );
        TMainDialog::SetControlEnable( DitherMipsCheckBox,	true );
        TMainDialog::SetControlEnable( SharpenMipCheckBox,	true );
        TMainDialog::SetControlEnable( AlphaFadeCheckBox,	true );
        TMainDialog::SetControlEnable( ColorFadeCheckBox,	true );
        MipTypeComboBox->ItemIndex      = opt->MipMapType - dMIPMapSourceFirst;
        MipFilterComboBox->ItemIndex    = opt->MIPFilterType - dMIPFilterFirst;
        MipNumberEdit->Text				= opt->SpecifiedMipMaps;
        MipNormCheckBox->Checked        = opt->bNormalizeMIPMaps;
        DitherMipsCheckBox->Checked     = opt->bDitherEachMIPLevel;
        SharpenMipCheckBox->Checked     = opt->bSharpenEachMIPLevel;
        AlphaFadeCheckBox->Checked      = opt->bFadeAlpha;
        ColorFadeCheckBox->Checked      = opt->bFadeColor;
	}
    else {
		TMainDialog::SetControlEnable( MipTypeComboBox,		false );
        TMainDialog::SetControlEnable( MipFilterComboBox,	false );
        TMainDialog::SetControlEnable( MipNumberEdit,		false );
        TMainDialog::SetControlEnable( MipNormCheckBox,		false );
        TMainDialog::SetControlEnable( DitherMipsCheckBox,	false );
        TMainDialog::SetControlEnable( SharpenMipCheckBox,	false );
        TMainDialog::SetControlEnable( AlphaFadeCheckBox,	false );
        TMainDialog::SetControlEnable( ColorFadeCheckBox,	false );
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateDxtFade	( void ) {
	CompressionOptions * opt = TMainDialog::DxtOptions();
    bool	afade = opt ? opt->bFadeAlpha : false;
    bool	cfade = opt ? opt->bFadeColor : false;
	itsUpdateFlag++;
    if	( (afade) || (cfade) ) {
    	TMainDialog::SetControlEnable( FadeRedTrackBar,		cfade );
        TMainDialog::SetControlEnable( FadeGreenTrackBar,	cfade );
        TMainDialog::SetControlEnable( FadeBlueTrackBar,	cfade );
        TMainDialog::SetControlEnable( FadeAlphaTrackBar,	afade );
        TMainDialog::SetControlEnable( FadeDelayTrackBar,	true );
        TMainDialog::SetControlEnable( FadeAmountTrackBar,	true );
        if	( cfade )	FadeRedTrackBar->Position	= opt->FadeToColor.c.rgba[0];
        if	( cfade )	FadeGreenTrackBar->Position = opt->FadeToColor.c.rgba[1];
        if	( cfade )	FadeBlueTrackBar->Position  = opt->FadeToColor.c.rgba[2];
		if	( afade )   FadeAlphaTrackBar->Position	= opt->FadeToAlpha;
        FadeDelayTrackBar->Position	= opt->FadeToDelay;
        FadeAmountTrackBar->Position= opt->FadeAmount;
		if	( cfade ) {
        	unsigned long	mycolor;
            mycolor = 	opt->FadeToColor.c.rgba[0] |
                        (opt->FadeToColor.c.rgba[1] << 8) |
                        (opt->FadeToColor.c.rgba[2] << 16);
	        FadeColorPanel->Color = (TColor)mycolor;
        }
        else {
	        FadeColorPanel->Color = clBtnFace;
        }
    }
    else {
    	TMainDialog::SetControlEnable( FadeRedTrackBar,		false );
        TMainDialog::SetControlEnable( FadeGreenTrackBar,	false );
        TMainDialog::SetControlEnable( FadeBlueTrackBar,	false );
        TMainDialog::SetControlEnable( FadeAlphaTrackBar,	false );
        TMainDialog::SetControlEnable( FadeDelayTrackBar,	false );
        TMainDialog::SetControlEnable( FadeAmountTrackBar,	false );
        FadeColorPanel->Color = clBtnFace;
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateDxtSharp	( void ) {
	CompressionOptions * opt = TMainDialog::DxtOptions();
    bool	sharpen = opt ? opt->bSharpenEachMIPLevel : false;
	itsUpdateFlag++;
    if	( sharpen ) {
    	AnsiString	fco;
    	TMainDialog::SetControlEnable( SharpRadiusTrackBar,			true );
        TMainDialog::SetControlEnable( SharpLambdaEdit,				true );
        TMainDialog::SetControlEnable( SharpMuEdit,					true );
        TMainDialog::SetControlEnable( SharpThetaEdit,				true );
        TMainDialog::SetControlEnable( Sharp2ComponentsCheckBox,	true );
        TMainDialog::SetControlEnable( SharpSuppressionCheckBox,	true );
        TMainDialog::SetControlEnable( SharpBlurCheckBox,			true );
        TMainDialog::SetControlEnable( SharpFlavor2CheckBox,		true );
        SharpRadiusTrackBar->Position       = opt->SharpenEdgeRadius;
        SharpLambdaEdit->Text				= fco.FormatFloat( "0.00000", opt->SharpenLambda );
        SharpMuEdit->Text					= fco.FormatFloat( "0.00000", opt->SharpenMu );
        SharpThetaEdit->Text				= fco.FormatFloat( "0.00000", opt->SharpenTheta );
        Sharp2ComponentsCheckBox->Checked   = opt->bSharpenUseTwoComponents;
        SharpSuppressionCheckBox->Checked	= opt->bSharpenNonMaximalSuppression;
        SharpBlurCheckBox->Checked          = opt->bSharpenSharpBlur;
        SharpFlavor2CheckBox->Checked       = opt->bSharpenFlavor2;
    }
    else {
    	TMainDialog::SetControlEnable( SharpRadiusTrackBar,			false );
        TMainDialog::SetControlEnable( SharpLambdaEdit,				false );
        TMainDialog::SetControlEnable( SharpMuEdit,					false );
        TMainDialog::SetControlEnable( SharpThetaEdit,				false );
        TMainDialog::SetControlEnable( Sharp2ComponentsCheckBox,	false );
        TMainDialog::SetControlEnable( SharpSuppressionCheckBox,	false );
        TMainDialog::SetControlEnable( SharpBlurCheckBox,			false );
        TMainDialog::SetControlEnable( SharpFlavor2CheckBox,		false );
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateDxtScale	( void ) {
	CompressionOptions * opt = TMainDialog::DxtOptions();
    bool	numer = opt ? opt->bRescaleImage > RESCALE_NEXT_SMALLEST_POWER2 : false;
	itsUpdateFlag++;
    if	( opt ) {
    	AnsiString	fco;
		TMainDialog::SetControlEnable( ScaleTypeComboBox,	true );
		TMainDialog::SetControlEnable( ScaleXEdit,			numer );
        TMainDialog::SetControlEnable( ScaleYEdit,			numer );
        ScaleTypeComboBox->ItemIndex = (int)(opt->bRescaleImage);
        if	( numer ) {
        	ScaleXEdit->Text	= fco.FormatFloat( "0.00000", opt->scaleX );
            ScaleYEdit->Text	= fco.FormatFloat( "0.00000", opt->scaleY );
        }
    }
    else {
		TMainDialog::SetControlEnable( ScaleTypeComboBox,	false );
		TMainDialog::SetControlEnable( ScaleXEdit,			false );
        TMainDialog::SetControlEnable( ScaleYEdit,			false );
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateDxtBorder	( void ) {
	CompressionOptions * opt = TMainDialog::DxtOptions();
	itsUpdateFlag++;
    if	( opt ) {
    	TMainDialog::SetControlEnable( AlphaBorderCheckBox,			true );
        TMainDialog::SetControlEnable( AlphaBorderTrackBar,			opt->bAlphaBorder );
        TMainDialog::SetControlEnable( ColorBorderCheckBox,			true );
        TMainDialog::SetControlEnable( ColorBorderRedTrackBar,		opt->bBorder );
        TMainDialog::SetControlEnable( ColorBorderGreenTrackBar,	opt->bBorder );
        TMainDialog::SetControlEnable( ColorBorderBlueTrackBar,		opt->bBorder );
        AlphaBorderCheckBox->Checked	= opt->bAlphaBorder;
        ColorBorderCheckBox->Checked    = opt->bBorder;
        if	( opt->bAlphaBorder ) {
	        AlphaBorderTrackBar->Position = opt->BorderColor.c.rgba[3];
        }
        if	( opt->bBorder ) {
	        ColorBorderRedTrackBar->Position    = opt->BorderColor.c.rgba[0];
            ColorBorderGreenTrackBar->Position	= opt->BorderColor.c.rgba[1];
            ColorBorderBlueTrackBar->Position   = opt->BorderColor.c.rgba[2];
        	unsigned long	mycolor;
            mycolor = 	opt->BorderColor.c.rgba[0] |
                        (opt->BorderColor.c.rgba[1] << 8) |
                        (opt->BorderColor.c.rgba[2] << 16);
	        ColorBorderPanel->Color = (TColor)mycolor;
        }
        else {
	        ColorBorderPanel->Color = clBtnFace;
        }
    }
    else {
    	TMainDialog::SetControlEnable( AlphaBorderCheckBox,			false );
        TMainDialog::SetControlEnable( AlphaBorderTrackBar,			false );
        TMainDialog::SetControlEnable( ColorBorderCheckBox,			false );
        TMainDialog::SetControlEnable( ColorBorderRedTrackBar,		false );
        TMainDialog::SetControlEnable( ColorBorderGreenTrackBar,	false );
        TMainDialog::SetControlEnable( ColorBorderBlueTrackBar,		false );
        ColorBorderPanel->Color = clBtnFace;
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::PopulateDxtOther	( void ) {
	CompressionOptions * opt = TMainDialog::DxtOptions();
	itsUpdateFlag++;
    if	( opt ) {
		TMainDialog::SetControlEnable( TextureTypeComboBox,		true );
        TMainDialog::SetControlEnable( AlphaThresholdTrackBar,	true );
        TMainDialog::SetControlEnable( DuDvCheckBox,			true );
        TMainDialog::SetControlEnable( Dither16CheckBox,		true );
        TMainDialog::SetControlEnable( SwapRGCheckBox,			true );
        TMainDialog::SetControlEnable( GreyScaleCheckBox,		true );
        TextureTypeComboBox->ItemIndex	 = opt->TextureType;
        AlphaThresholdTrackBar->Position = opt->BinaryAlphaThreshold;
        DuDvCheckBox->Checked       = opt->bDuDvMap;
        Dither16CheckBox->Checked   = opt->bDitherColor;
        SwapRGCheckBox->Checked     = opt->bSwapRGB;
        GreyScaleCheckBox->Checked	= opt->bGreyScale;
    }
    else {
		TMainDialog::SetControlEnable( TextureTypeComboBox,		false );
        TMainDialog::SetControlEnable( AlphaThresholdTrackBar,	false );
        TMainDialog::SetControlEnable( DuDvCheckBox,			false );
        TMainDialog::SetControlEnable( Dither16CheckBox,		false );
        TMainDialog::SetControlEnable( SwapRGCheckBox,			false );
        TMainDialog::SetControlEnable( GreyScaleCheckBox,		false );
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::DriveComboBoxChange(TObject *Sender) {
	// Drive changed
	if	( itsUpdateFlag )	return;
    itsDoc.Drive( (char)(DriveComboBox->Drive - 'A') );
    FileListCheckListBox->Items->Clear();
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FileListCheckListBoxDblClick(TObject *Sender) {
	// Double click of file list
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;

	// Get the item we have here
    AnsiString	item = FileListCheckListBox->Items->Strings[FileListCheckListBox->ItemIndex];

	// It is either select or directory change
	if	( item.SubString( 1, 1 ).AnsiCompare( "<" ) == 0 ) {
    	item = item.SubString( 2, item.Length() - 2 );
		::chdir( item.c_str() );
	    itsDoc.Drive( itsDoc.Drive() );
	    FileListCheckListBox->Items->Clear();
    }
    else {
		FileListCheckListBox->Checked[FileListCheckListBox->ItemIndex] = true;
    	itsDoc.Item( FileListCheckListBox->ItemIndex ).Select( true );
    }
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FileListCheckListBoxClick(TObject *Sender) {
	// File list clicked
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FileListCheckListBoxClickCheck(TObject *Sender) {
	// File list checkbox clicked
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;

	// Get the item we have here
    AnsiString	item = FileListCheckListBox->Items->Strings[FileListCheckListBox->ItemIndex];

	// It is either select or directory change
	if	( item.SubString( 1, 1 ).AnsiCompare( "<" ) == 0 ) {
		FileListCheckListBox->Checked[FileListCheckListBox->ItemIndex] = false;
    }
    else {
    	itsDoc.Item( FileListCheckListBox->ItemIndex ).Select( FileListCheckListBox->Checked[FileListCheckListBox->ItemIndex] );
    }
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::CompressionRadioGroupClick(TObject *Sender) {
	// Texture type combo changed
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;
	itsDoc.Item( FileListCheckListBox->ItemIndex ).TextureType( CompressionRadioGroup->ItemIndex );
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MipMapsCheckBoxClick(TObject *Sender) {
	// Mipmaps checkbox clicked
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;
	itsDoc.Item( FileListCheckListBox->ItemIndex ).MipMaps( MipMapsCheckBox->Checked );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MaskedCheckBoxClick(TObject *Sender) {
	// Masked checkbox clicked
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;
	itsDoc.Item( FileListCheckListBox->ItemIndex ).Masked( MaskedCheckBox->Checked );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::AlphaCheckBoxClick(TObject *Sender) {
	// Alpha checkbox clicked
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;
	itsDoc.Item( FileListCheckListBox->ItemIndex ).Alpha( AlphaCheckBox->Checked );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GroupEditChange(TObject *Sender) {
	// Group name edited
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;
	itsDoc.Item( FileListCheckListBox->ItemIndex ).Group( GroupEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::NameEditChange(TObject *Sender) {
	// Object name edited
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;
	itsDoc.Item( FileListCheckListBox->ItemIndex ).Name( NameEdit->Text.c_str() );
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::TextureFileEditChange(TObject *Sender) {
	// Package name edited
	if	( itsUpdateFlag )	return;
    itsDoc.TextureFile( TextureFileEdit->Text.c_str() );
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SelectAllButtonClick(TObject *Sender) {
	// Select all files
	if	( itsUpdateFlag )	return;
	itsUpdateFlag++;
    int			idx;
   	AnsiString	item;
	for	( idx = 0; idx < FileListCheckListBox->Items->Count; idx++ ) {
    	item = FileListCheckListBox->Items->Strings[idx];
		if	( item.SubString( 1, 1 ).AnsiCompare( "<" ) != 0 ) {
			FileListCheckListBox->Checked[idx] = true;
			itsDoc.Item( idx ).Select( true );
	    }
    }
	itsUpdateFlag--;
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ClearAllButtonClick(TObject *Sender) {
	// Clear all files
	// Select all files
	if	( itsUpdateFlag )	return;
	itsUpdateFlag++;
    int			idx;
	for	( idx = 0; idx < FileListCheckListBox->Items->Count; idx++ ) {
		FileListCheckListBox->Checked[idx] = false;
    }
	itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ApplyToAllButtonClick(TObject *Sender) {
	// Apply to all button clicked
	if	( itsUpdateFlag )	return;
    if	( FileListCheckListBox->ItemIndex < 0 )	return;

    CUtxFile	item = itsDoc.Item( FileListCheckListBox->ItemIndex );
	if	( item.Directory() )	return;
    itsDoc.Propagate( item );
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ConvertButtonClick(TObject *Sender) {
	unsigned int	thread_id = 0;
	if	( ::BeginThread( NULL, 32768, CompressionThread, &itsDoc, 0, thread_id ) > 0 ) {
		SLEEP(100);
        if	( ! itsDoc.CompressDon() ) {
		   	Application->CreateForm( __classid(TProgressDialog), &ProgressDialog );
            ProgressDialog->Doc = &itsDoc;
			ProgressDialog->ShowModal();
	        Application->OnIdle = NULL;
		    ProgressDialog->Release();
			ProgressDialog = NULL;
        }
    }
    TMainDialog::Populate();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MipTypeComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->MipMapType = (short)(MipTypeComboBox->ItemIndex + dMIPMapSourceFirst);
    }
    TMainDialog::PopulateDxtMips();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MipFilterComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->MIPFilterType = (short)(MipFilterComboBox->ItemIndex + dMIPFilterFirst);
    }
    TMainDialog::PopulateDxtMips();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MipNumberEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->SpecifiedMipMaps = (short)::atoi( MipNumberEdit->Text.c_str() );
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::MipNormCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bNormalizeMIPMaps = MipNormCheckBox->Checked;
    }
    TMainDialog::PopulateDxtMips();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::DitherMipsCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bDitherEachMIPLevel = DitherMipsCheckBox->Checked;
    }
    TMainDialog::PopulateDxtMips();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpenMipCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bSharpenEachMIPLevel = SharpenMipCheckBox->Checked;
    }
    TMainDialog::PopulateDxtMips();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::AlphaFadeCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bFadeAlpha = AlphaFadeCheckBox->Checked;
    }
    TMainDialog::PopulateDxtMips();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ColorFadeCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bFadeColor = ColorFadeCheckBox->Checked;
    }
    TMainDialog::PopulateDxtMips();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FadeRedTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->FadeToColor.c.rgba[0] = (BYTE)FadeRedTrackBar->Position;
    }
    TMainDialog::PopulateDxtFade();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FadeGreenTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->FadeToColor.c.rgba[1] = (BYTE)FadeGreenTrackBar->Position;
    }
    TMainDialog::PopulateDxtFade();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FadeBlueTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->FadeToColor.c.rgba[2] = (BYTE)FadeBlueTrackBar->Position;
    }
    TMainDialog::PopulateDxtFade();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FadeAlphaTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->FadeToAlpha = FadeAlphaTrackBar->Position;
    }
    TMainDialog::PopulateDxtFade();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FadeDelayTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->FadeToDelay = FadeDelayTrackBar->Position;
    }
    TMainDialog::PopulateDxtFade();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::FadeAmountTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->FadeAmount = FadeAmountTrackBar->Position;
    }
    TMainDialog::PopulateDxtFade();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpRadiusTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->SharpenEdgeRadius = SharpRadiusTrackBar->Position;
    }
    TMainDialog::PopulateDxtSharp();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpLambdaEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->SharpenLambda = (float)::atof( SharpLambdaEdit->Text.c_str() );
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpMuEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->SharpenMu = (float)::atof( SharpMuEdit->Text.c_str() );
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpThetaEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->SharpenTheta = (float)::atof( SharpThetaEdit->Text.c_str() );
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::Sharp2ComponentsCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bSharpenUseTwoComponents = Sharp2ComponentsCheckBox->Checked;
    }
    TMainDialog::PopulateDxtSharp();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpSuppressionCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bSharpenNonMaximalSuppression = SharpSuppressionCheckBox->Checked;
    }
    TMainDialog::PopulateDxtSharp();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpBlurCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bSharpenSharpBlur = SharpBlurCheckBox->Checked;
    }
    TMainDialog::PopulateDxtSharp();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SharpFlavor2CheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bSharpenFlavor2 = SharpFlavor2CheckBox->Checked;
    }
    TMainDialog::PopulateDxtSharp();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScaleTypeComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bRescaleImage = (RescaleOption)(ScaleTypeComboBox->ItemIndex);
    }
    TMainDialog::PopulateDxtScale();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScaleXEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
   		opt->scaleX = (float)::atof(ScaleXEdit->Text.c_str());
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ScaleYEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->scaleY = (float)::atof(ScaleYEdit->Text.c_str());
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::AlphaBorderCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bAlphaBorder = AlphaBorderCheckBox->Checked;
    }
    TMainDialog::PopulateDxtBorder();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::AlphaBorderTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->BorderColor.c.rgba[3] = (BYTE)AlphaBorderTrackBar->Position;
    }
    TMainDialog::PopulateDxtBorder();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ColorBorderCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bBorder = ColorBorderCheckBox->Checked;
    }
    TMainDialog::PopulateDxtBorder();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ColorBorderRedTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->BorderColor.c.rgba[0] = (BYTE)ColorBorderRedTrackBar->Position;
    }
    TMainDialog::PopulateDxtBorder();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ColorBorderGreenTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->BorderColor.c.rgba[1] = (BYTE)ColorBorderGreenTrackBar->Position;
    }
    TMainDialog::PopulateDxtBorder();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::ColorBorderBlueTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->BorderColor.c.rgba[2] = (BYTE)ColorBorderBlueTrackBar->Position;
    }
    TMainDialog::PopulateDxtBorder();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::TextureTypeComboBoxChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->TextureType = (short)(TextureTypeComboBox->ItemIndex);
    }
    TMainDialog::PopulateDxtOther();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::AlphaThresholdTrackBarChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->BinaryAlphaThreshold = AlphaThresholdTrackBar->Position;
    }
    TMainDialog::PopulateDxtOther();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::DuDvCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bDuDvMap = DuDvCheckBox->Checked;
    }
    TMainDialog::PopulateDxtOther();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::Dither16CheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bDitherColor = Dither16CheckBox->Checked;
    }
    TMainDialog::PopulateDxtOther();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::SwapRGCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bSwapRGB = SwapRGCheckBox->Checked;
    }
    TMainDialog::PopulateDxtOther();
}

//---------------------------------------------------------------------------
void __fastcall TMainDialog::GreyScaleCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	CompressionOptions * opt = TMainDialog::DxtOptions();
	if	( opt ) {
    	opt->bGreyScale = GreyScaleCheckBox->Checked;
    }
    TMainDialog::PopulateDxtOther();
}

//---------------------------------------------------------------------------

