// --------------------------------------------------------------------
// CAuthor.hxx
// Whatis:	Class for author name detection and manipulation
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CAuthor_hxx
#define	CAuthor_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------------
// Declaration of the CAuthor class
// --------------------------------------------------------------------
class	CAuthor {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CAuthor	();
	CAuthor	( dword_t 		aFileIdnt, bool aCreateRecord = false );
	CAuthor	( const char *	aFileName, bool aCreateRecord = false );
	CAuthor	( const char *	aFileName, const char * aFileCsum, bool aCreateRecord = false );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CAuthor();

	// ----------------------------------------------------------------
	public:		// Copy	constructor	and	assignment operators
	// ----------------------------------------------------------------
	CAuthor					( const CAuthor & );
	CAuthor & operator	=	( const CAuthor & );

	// ----------------------------------------------------------------
	public:		// Accessing the instance data
	// ----------------------------------------------------------------
	dword_t			AuthorId	( void ) const { return itsAuthorId; }
	const char *	FirstName	( void ) const { return itsFirstName; }
	const char *	NickName	( void ) const { return itsNickName; }
	const char *	LastName	( void ) const { return itsLastName; }
	const char *	LongName	( void ) const { return itsLongName; }
	bool			Complete	( void ) const { return itsComplete; }
	void			SetNames	( const char * aLongName );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void		Cleanup 			( void );
	void		Free				( void );
	bool		AuthorForFile		( const char * aFileName );
	void		CreateAuthor		( void );
	bool		TryUnreal			( const char * aFileName );
	bool		TryTEXT				( const char * aFileName );
	bool		IsTEXT				( const char * aFileName );
	bool		TryTextLine			( const char * aLine );
	void		MakeLongName		( void );
	void		PrepareLine			( char * aLine );
	dword_t		RankLine			( const char * aLine, dword_t aBestRank );
	char *		UseRankLine			( char * aLine, dword_t aRank );
	bool		TryCsum				( const char * aCsum );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t		itsAuthorId;
	bool		itsComplete;
	char *		itsFirstName;
	char *		itsNickName;
	char *		itsLastName;
	char *		itsLongName;
};

#endif	// #ifdef  CAuthor_hxx
// --------------------------------------------------------------------
// EOF:	CAuthor.hxx
// --------------------------------------------------------------------
