// --------------------------------------------------------------------
// CCache.hxx
// Whatis:	Class for caching files
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CCache_hxx
#define	CCache_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------------
// Declaration of the CCache class
// --------------------------------------------------------------------
class	CCache {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CCache ( const char * aCacheName );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CCache() {}

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	bool			Exist		( const char * aFileName );
	void			Cache		( const char * aFileName );
	char *			MakeDirname	( char * aBuff, const char * aFileName );
	dword_t			MaxFiles	( void ) const { return itsMaxFiles; }
	dword_t			MaxSize		( void ) const { return itsMaxSize; }
	const char *	UrlBase		( void ) const { return itsUrlBase; }
	const char *	DirBase		( void ) const { return itsDirBase; }

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CCache					( const CCache & );
	CCache & operator	=	( const CCache & );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t			itsMaxFiles;
	dword_t			itsMaxSize;
	char			itsUrlBase	[100];
	char			itsDirBase	[100];
};

#endif	// #ifdef  CCache_hxx
// --------------------------------------------------------------------
// EOF:	CCache.hxx
// --------------------------------------------------------------------
