// --------------------------------------------------------------------
// CGzip.hxx
// Whatis:	Class for compression / decompression
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CGzip_hxx
#define	CGzip_hxx
#include	"Platform.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzip class
// --------------------------------------------------------------------
class	CGzip {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CGzip ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CGzip();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CGzip			  	  (	const CGzip & );
	CGzip & operator	= (	const CGzip & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	dword_t		Gzip	( 	const char *	aGzFile,
							const char *	aDataFile );

	void		Gunzip	(	const char *	aDataFile,
							const char *	aGzFile );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void		Zerror	(	int				aZerrno,
							const char *	aFileName );
};

#endif	// #ifdef  CGzip_hxx
// --------------------------------------------------------------------
// EOF:	CGzip.hxx
// --------------------------------------------------------------------
