// --------------------------------------------------------------------
// CIdentifyFile.hxx
// Whatis:	Class for identifying incoming files
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CIdentifyFile_hxx
#define	CIdentifyFile_hxx
#include	"CTableType.hxx"
#include	"CUnUmod.hxx"
#include	"CUnUtils.hxx"

// --------------------------------------------------------------------
// Declaration of the CIdentifyFile class
// --------------------------------------------------------------------
class	CIdentifyFile {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CIdentifyFile ( const char * aFileName, const char * aFileCsum = NULL );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CIdentifyFile();

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	data_type_t		Type		( void ) const { return itsType; }
	const char *	Typ1		( void ) const { return itsTyp1; }
	const char *	Ctgr		( void ) const { return itsCtgr; }
	const char *	Typ2		( void ) const { return itsTyp2; }
	const char *	FileName	( void ) const { return itsFileName; }
	const char *	Path		( void ) const { return itsPath; }
	const char *	Name		( void ) const { return itsName; }
	const char *	Suff		( void ) const { return itsSuff; }
	const char *	Author		( void ) const { return itsAuthor; }
	dword_t			AuthorId	( void ) const { return itsAuthorId; }
	const char *	Title		( void ) const { return itsTitle; }
	const char *	UnpackMethod( void ) const { return itsUnpack; }

	word_t			PackageVersion		( void ) const { return	itsPackageVersion; }
	word_t			LicenseeMode		( void ) const { return	itsLicenseeMode; }

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			ScanRules	( void );
	bool			TryRule		( const char * aRule );
	bool			TrySuff		( const char * aSuff );
	bool			TryPref		( const char * aPref );
	bool			TryFile		( const char * aFile );
	bool			TrySign		( const char * aSign );
	bool			TryNeeds	( const char * aPackage );
	bool			TryHasnot	( const char * aPackage );
	bool			TryActor	( const char * aActor,
								  const char * aArg1,
								  const char * aArg2 );
	bool			TryTexture	( const char * aTexture );
	bool			TryFunction	( const char * aFunction );
	bool			TryUT		( void );
	bool			TryUT2k3	( void );
	bool			TryAAO		( void );
	bool			TryU1		( void );
	bool			TryEXE		( void );
	void			LoadUNR		( void );
	void			LoadUMOD	( void );
	void			Cleanup		( void );
	void			Free		( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	CUnUtils *		itsUnUtils;
	bool			itsUmod;
	bool			itsExe;
	bool			itsU1;
	bool			itsUT;
	bool			itsAAO;
	bool			itsUT2k3;
	struct stat		itsStat;
	data_type_t		itsType;
	char			itsTyp1		[9];
	char			itsCtgr		[65];
	char			itsTyp2		[17];
	char			itsFileName	[201];
	char			itsPath		[101];
	char			itsName		[64];
	char			itsSuff		[31];
	char			itsAuthor	[101];
	char			itsTitle	[101];
	char			itsUnpack	[32];
	word_t			itsPackageVersion;
	word_t			itsLicenseeMode;
	dword_t			itsAuthorId;
};

#endif	// #ifdef  CIdentifyFile_hxx
// --------------------------------------------------------------------
// EOF:	CIdentifyFile.hxx
// --------------------------------------------------------------------
