// --------------------------------------------------------------------
// CImportFile.hxx
// Whatis:	Importing files to the system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CImportFile_hxx
#define	CImportFile_hxx
#include	"CIdentifyFile.hxx"
#include	"CTableUser.hxx"
#include	"CTablePack.hxx"

// --------------------------------------------------------------------
// Declaration of the CIdentifyFile class
// --------------------------------------------------------------------
class	CImportFile {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CImportFile ( const char * aUser, bool aSilent = false );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CImportFile();

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Import		(	const char *	aFilePath,
									const char *	aTempDir = NULL );
	data_user_t		User		( void ) const { return itsUser; }
	data_pack_tl	PackList	( void ) const { return itsPackList; }

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void		ImportPack	(	const char *	aPack,
								dir_file_tl &	aList );
	void		ImportDir	( 	dir_file_tl	&	aList,
								const char * 	aDir );
	void		ImportUmod	( 	CIdentifyFile &	aIdent );
	void		ImportGzip	( 	CIdentifyFile &	aIdent );
	void		ImportZip	( 	CIdentifyFile &	aIdent );
	void		ImportTar	( 	CIdentifyFile &	aIdent );
	void		ImportStuf	( 	dir_file_tl &	aList,
								const char *	aFile );
	void		CreateXref	(	CMySqlConnect &	aDb,
								dword_t			aFileIdnt,
								const char *	aFile );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	data_user_t		itsUser;
	data_pack_tl	itsPackList;
	const char *	itsTempDir;
	bool			itsSilent;
};

#endif	// #ifdef  CImportFile_hxx
// --------------------------------------------------------------------
// EOF:	CImportFile.hxx
// --------------------------------------------------------------------
