// --------------------------------------------------------------------
// CPreviewScore.hxx
// Whatis:	Class for previewing scores
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewScore_hxx
#define	CPreviewScore_hxx

#include	"CMySqlConnect.hxx"
#include	"CTableFile.hxx"
#include	"CTableVote.hxx"
#include	"CCgiArgs.hxx"

// --------------------------------------------------------------------
// Declaration of the CPreviewScore class
// --------------------------------------------------------------------
class	CPreviewScore {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewScore ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewScore();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewScore					( const CPreviewScore & );
	CPreviewScore & operator	=	( const CPreviewScore & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	bool		Answer	( const data_file_t &, const CCgiArgs &, const char *, CMySqlConnect & );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	bool		GodScore	( const data_file_t & )	const;
	bool		AvgScore	( const data_file_t & )	const;
	bool		BadScore	( const data_file_t & )	const;
	bool		GodState	( const data_file_t &, const CCgiArgs &, CMySqlConnect & );
	bool		AvgState	( const data_file_t &, const CCgiArgs &, CMySqlConnect & );
	bool		BadState	( const data_file_t &, const CCgiArgs &, CMySqlConnect & );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CTableVote	itsVote;
};

#endif	// #ifdef  CPreviewScore_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewScore.hxx
// --------------------------------------------------------------------
