// --------------------------------------------------------------------
// CPreviewShots.hxx
// Whatis:	Class for previewing screenshots
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewShots_hxx
#define	CPreviewShots_hxx

#include	"Platform.hxx"

#define	MAX_SCREENSHOT	64	// We only take the 64 first screenies

// --------------------------------------------------------------------
// Declaration of the CPreviewShots class
// --------------------------------------------------------------------
class	CPreviewShots {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewShots ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewShots();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewShots			  (	const CPreviewShots & );
	CPreviewShots & operator	= (	const CPreviewShots & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Load		( 	const char *	aUrlFile,
									dword_t			aFileIdnt,
									dword_t			aDetailIx );
	bool			Answer		( const char * aQ ) const;
	const char *	Thumbnail	( dword_t aIdx )	const	{ return itsThumbnail[aIdx]; }
	const char *	DetailShot	( void )			const	{ return itsDetailShot; }
	const char *	BaseUrl		( void )			const	{ return itsBaseUrl; }
	const char *	BasePath	( void )			const	{ return itsBasePath; }
	dword_t			ShotIdx		( void )			const	{ return itsShotIdx; }
	void			ShotIdx		( dword_t aIdx )			{ itsShotIdx = aIdx; }
	dword_t			ShotCount	( void )			const	{ return itsShotCount; }

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			Cleanup		( void );
	void			Free		( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char			itsThumbnail	[MAX_SCREENSHOT][128];
	char			itsDetailShot	[128];
	char			itsBaseUrl		[1024];
	char			itsBasePath		[1024];
	dword_t			itsShotIdx;
	dword_t			itsShotCount;
};

#endif	// #ifdef  CPreviewShots_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewShots.hxx
// --------------------------------------------------------------------
