// --------------------------------------------------------------------
// CPreviewTemplate.hxx
// Whatis:	Class for template executing
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewTemplate_hxx
#define	CPreviewTemplate_hxx

#include	"Platform.hxx"

#define	MAX_TEMPLATES	32

// --------------------------------------------------------------------
// Declaration of the CPreviewTemplate class
// --------------------------------------------------------------------
class	CPreviewTemplate {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewTemplate ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewTemplate();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewTemplate			  (	const CPreviewTemplate & );
	CPreviewTemplate & operator	= (	const CPreviewTemplate & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Execute		(	parse_ask_fun_tp	aCallback,
									const char *		aTemplateName );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			Cleanup		( void );
	void			Free		( void );
	const char *	Cache		( const char * aTemplateName );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char *			itsCacheName[MAX_TEMPLATES];
	char *			itsCacheData[MAX_TEMPLATES];

};

#endif	// #ifdef  CPreviewTemplate_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewTemplate.hxx
// --------------------------------------------------------------------
