// --------------------------------------------------------------------
// CPreviewText.hxx
// Whatis:	Class for managing sessions
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewText_hxx
#define	CPreviewText_hxx
#include	"CTableFile.hxx"

// --------------------------------------------------------------------
// Declaration of the CPreviewText class
// --------------------------------------------------------------------
class	CPreviewText {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewText ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewText();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewText			  (	const CPreviewText & );
	CPreviewText & operator	= (	const CPreviewText & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void					OutputRaw		( dword_t aFileIdnt );
	void					OutputHttp		( dword_t aFileIdnt );
	void					OutputHttp		( FILE *, dword_t );
	void					OutputHttpBr	( dword_t aFileIdnt );
	void					OutputUBB		( dword_t aFileIdnt );


	const data_file_t &		File	( void )	const	{ return itsFile; }
	const char *			BaseUrl	( void )	const	{ return itsBaseUrl; }
	const char *			FileName( void )	const	{ return itsFileName; }
	const char *			FilePath( void )	const	{ return itsFilePath; }

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	const char *	UbbParse		( const char * aP );
	const char *	UbbParseImg		( const char * aP );
	const char *	UbbParseHtml	( const char * aP );
	const char *	UbbParseBUI		( const char * aP, const char * aTerm, const char * aTag );
	const char *	UbbParseLink	( const char * aP, const char * aTerm, const char * aTag, const char * aTarg );
	const char *	UbbParseFont	( const char * aP, const char * aTerm, const char * aTag );
	const char *	UbbParseBorder	( const char * aP );
	void			Cleanup			( void );
	void			Free			( void );
	char *			LoadFile		( dword_t );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	data_file_t		itsFile;
	char			itsBaseUrl	[1024];
	char			itsFileName	[1024];
	char			itsFilePath	[1024];
};

#endif	// #ifdef  CPreviewText_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewText.hxx
// --------------------------------------------------------------------
