// --------------------------------------------------------------------
// CPreviewUpack.hxx
// Whatis:	Class for previewing screenshots
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewUpack_hxx
#define	CPreviewUpack_hxx

#include	"CUnFile.hxx"

// --------------------------------------------------------------------
// Declaration of the CPreviewUpack class
// --------------------------------------------------------------------
class	CPreviewUpack {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewUpack ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewUpack();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewUpack			  (	const CPreviewUpack & );
	CPreviewUpack & operator	= (	const CPreviewUpack & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Load		( const char * aUnrFile );
	bool			Answer		( const char * aQ ) const;

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			Cleanup		( void );
	void			Free		( void );
	const char *	Unrflags	( dword_t aMask ) const;

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	CUnFile *		itsUnFile;
};

#endif	// #ifdef  CPreviewUpack_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewUpack.hxx
// --------------------------------------------------------------------
