// --------------------------------------------------------------------
// CFurpileLogo.cxx
// Whatis:	Download manager
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CFurpileLogo.hxx"
#include	"CUnTexture.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CFurpileLogo::CFurpileLogo	( const char * aUtxFile ) {
	try	{
		CUnFile			f( aUtxFile );
		CUnExportTable	e( f );
		CUnImportTable	i( f );
		CUnNameTable	n( f );

		// Seek the logo into place and read in the texture
		dword_t	ex0	= n.Find( "Logo0" );
		dword_t	ex1	= n.Find( "Logo1" );
		dword_t	ex2	= n.Find( "Logo2" );
	    dword_t	exloop;

		for ( exloop = 0; exloop < e.Count(); exloop++ ) {
			CUnExport   exprt = e.Export( exloop );

			if		( exprt.ObjectName() == ex0 ) {
				f.Seek( exprt.SerialOffset() );
				CUnTexture	texture( f, n, e, i );
				itsPixmap[0] = texture.Pixmap();
			}
			else if	( exprt.ObjectName() == ex1 ) {
				f.Seek( exprt.SerialOffset() );
				CUnTexture	texture( f, n, e, i );
				itsPixmap[1] = texture.Pixmap();
			}
			else if	( exprt.ObjectName() == ex2 ) {
				f.Seek( exprt.SerialOffset() );
				CUnTexture	texture( f, n, e, i );
				itsPixmap[2] = texture.Pixmap();
			}
		}
	}

	catch	( CError e ) {
		throw	CError( "CFurpileLogo::CFurpileLogo", e.Error() );
	}

	catch	( ... ) {
		throw	CError( "CFurpileLogo::CFurpileLogo", "unknown" );
	}
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CFurpileLogo::~CFurpileLogo	( ) {
}

// --------------------------------------------------------------------
// public:		Plant a logo into the destination image
// --------------------------------------------------------------------
void	CFurpileLogo::Plant	( CPicturePixmap &	aPixmap ) const {
	dword_t		logo_s	= aPixmap.W();
	dword_t		logo_x	= 0;
	if	( logo_s > aPixmap.H() )	logo_s = aPixmap.H();

	// Determine the size of the logo to draw
	if		( logo_s < 128 )	return;
	else if	( logo_s < 256 )	logo_x = 2;
	else if	( logo_s < 512 )	logo_x = 1;
	else						logo_x = 0;

	// Plant the image into the destination image
	dword_t			x, y;
	dword_t			dx = aPixmap.W() - itsPixmap[logo_x].W() - 3;
	CPicturePixel	pixel;
	CPicturePixel	ipx;

	for	( x = 0; x < itsPixmap[logo_x].W(); x++ ) {
		for	( y = 0; y < itsPixmap[logo_x].H(); y++ ) {
			pixel	= itsPixmap[logo_x].Pixel( x, y );
			if	( ( pixel.R() > 16 ) ||
				  ( pixel.G() > 16 ) ||
				  ( pixel.B() > 16 ) ) {
				ipx = aPixmap.Pixel( dx + x, y + 3 );
				pixel.A( ipx.A() );
				pixel.R( (byte_t)( ( (word_t)pixel.R() + 3 * (word_t)ipx.R()) / 4) );
				pixel.G( (byte_t)( ( (word_t)pixel.G() + 3 * (word_t)ipx.G()) / 4) );
				pixel.B( (byte_t)( ( (word_t)pixel.B() + 3 * (word_t)ipx.B()) / 4) );
				aPixmap.Pixel( dx + x, y + 3, pixel );
			}
		}
	}
}

// --------------------------------------------------------------------
// EOF:	CFurpileLogo.cxx
// --------------------------------------------------------------------
