// --------------------------------------------------------------------
// CIpLimit.cxx
// Whatis:	Class for detecting spam
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	20-APR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CIpLimit.hxx"

// --------------------------------------------------------------------
// The data file record
// --------------------------------------------------------------------
typedef	struct {
	dword_t	count;
	time_t	etime;
	char	addr	[32];
}	my_iplimit_t;

// --------------------------------------------------------------------
// public:	Constructor
// --------------------------------------------------------------------
CIpLimit::CIpLimit ( 	const char *	aIpAddress,
						dword_t			aLimit ) {
	itsDenyFlag = true;
	itsLimit	= aLimit;
	CIpLimit::Increment( aIpAddress );
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CIpLimit::~CIpLimit ( ) {
	CIpLimit::Decrement();
}

// --------------------------------------------------------------------
// public:	Ask for permission
// --------------------------------------------------------------------
bool	CIpLimit::Allow	( void ) const {
	return	itsDenyFlag == false;
}

// --------------------------------------------------------------------
bool	CIpLimit::Deny	( void ) const {
	return	itsDenyFlag;
}

// --------------------------------------------------------------------
void	CIpLimit::Increment		( const char * aIp ) {
	my_iplimit_t	record;
	FILE *			dats = ::fopen( "./cgitemp/CIpLimit.dat", "r+b" );
	if	( ! dats ) {
		dats = ::fopen( "./cgitemp/CIpLimit.dat", "wb" );
	}

	if	( dats ) {
		dword_t			freerecord	= 10;
		dword_t			recordnow	= 0;
		bool			hasrecord	= false;

		::fseek( dats, 0, SEEK_SET );

		while	( ::fread( &record, sizeof( record ), 1, dats ) == 1 ) {
			if		( record.count == 0 ) {
				freerecord = recordnow;
			}
			else if	( ! ::strcmp( aIp, record.addr ) ) {
				hasrecord = true;
				break;
			}
			else {
				recordnow += sizeof( record );
			}
		}

		if		( hasrecord ) {
			record.count++;
			if		( record.etime < ::time( NULL ) - 36000 ) {
				record.count = 1;
			}
			else if	( record.etime < ::time( NULL ) - 600 ) {
				if	( record.count > itsLimit ) {
					record.count = itsLimit;
				}
			}
		}
		else {
			if	( freerecord != 10 )	recordnow = freerecord;
			::memset( &record, 0, sizeof( record ) );
			::my_strfit( record.addr, sizeof(record.addr), aIp );
			record.count = 1;
		}

		itsDenyFlag		= (record.count > itsLimit);
		itsRecordNum	= recordnow;

		record.etime = ::time( NULL );

		::fseek( dats, recordnow, SEEK_SET );
		::fwrite( &record, sizeof( record ), 1, dats );

		::fclose( dats );
	}
}

// --------------------------------------------------------------------
void	CIpLimit::Decrement		( void ) {
	dword_t			count;
	FILE *			dats = ::fopen( "./cgitemp/CIpLimit.dat", "r+b" );
	if	( dats ) {
		if	( ! ::fseek( dats, itsRecordNum, SEEK_SET ) ) {
			if	( ::fread( &count, sizeof( count ), 1, dats ) == 1 ) {
				if	( count )	count--;
				if	( ! ::fseek( dats, itsRecordNum, SEEK_SET ) ) {
					::fwrite( &count, sizeof( count ), 1, dats );
				}
			}
		}
		::fclose( dats );
	}
}

// --------------------------------------------------------------------
// EOF:	CIpLimit.cxx
// --------------------------------------------------------------------
