// --------------------------------------------------------------------
// CPreviewAssaultShots.cxx
// Whatis:	Screenshot preview system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewAssaultShots.hxx"
#include	"CError.hxx"
#include	"CCache.hxx"
#include	"CUnAssaultInfo.hxx"
#include	"CPicture.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CPictureFilterAlphaBlend.hxx"
#include	"CFurpileLogo.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewAssaultShots::CPreviewAssaultShots ( void ) {
	CPreviewAssaultShots::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewAssaultShots::~CPreviewAssaultShots ( void ) {
	CPreviewAssaultShots::Free();
}

// --------------------------------------------------------------------
// public:		Load the information
// --------------------------------------------------------------------
void	CPreviewAssaultShots::Load	(	const char * 	aUnrFile,
								dword_t			aFileIdnt,
								dword_t			aDetailShot ) {
	try	{
		CPreviewAssaultShots::Free();

		CUnFile			f( aUnrFile );
		CUnNameTable	n( f );
		CUnImportTable	i( f );
		CUnExportTable	e( f );
		CUnAssaultInfo	l( f, n, e, i );
		CCache			mycache( "preview" );

		// Set up the default URL and path
		::strcpy( itsBaseUrl, mycache.UrlBase() );
		::strcpy( itsBasePath, mycache.DirBase() );

		for	( itsShotCount = 0; itsShotCount < l.Count(); itsShotCount++ ) {

			// Don't exceed out limits
			if	( itsShotCount == MAX_ASSAULTSHOT )	break;

			if	( l.Desc( itsShotCount ) ) {
				itsBriefing[itsShotCount] = ::my_private_strdup( l.Desc( itsShotCount ) );
			}
			else {
				itsBriefing[itsShotCount] = ::my_private_strdup( "No briefing available" );
			}

			// Set up the thumbnail file name
			::sprintf( itsThumbnail[itsShotCount], "%d-bshttn-%d.jpg", aFileIdnt, itsShotCount );

			// If this is the default one, set default shot name as well
			if	( aDetailShot == itsShotCount ) {
				::sprintf( itsDetailShot, "%d-bsht-%d.jpg", aFileIdnt, itsShotCount );
			}


			// Set up path names
			char	thmbpath[1024];
			char	detapath[1024];

			mycache.MakeDirname( thmbpath, itsThumbnail[itsShotCount] );
			mycache.MakeDirname( detapath, itsDetailShot );

			// Should we process the image ?
			if		( ( ! mycache.Exist( thmbpath ) ) ||
					  ( ( aDetailShot == itsShotCount ) && ( ! mycache.Exist( detapath ) ) ) ) {

				CPicture					mypicture;
				CPictureSourceUTX			myutx( l.Shot( itsShotCount ) );
				CPictureFilterAlphaBlend	alphablend( 0x1b, 0x00, 0x3e, 0xff );

				// Load the picture and take care of the alpha
				mypicture.Load( myutx );
				mypicture.Filter( alphablend );

				// Create full size shot if this is the detail shot
				if	( aDetailShot == itsShotCount ) {
					CFurpileLogo		logo( "Furpile.utx" );
					CPictureSourceJPG	myjpg( detapath, 70 );

					logo.Plant( mypicture.PixmapRef() );
					mypicture.Save( myjpg );
					mycache.Cache( detapath );
				}

				if	( ! mycache.Exist( thmbpath ) ) {
					CPictureFilterScale	thumbnail( 64, 64 );
					CPictureSourceJPG	myjpg( thmbpath, 70 );

					mypicture.Filter( thumbnail );
					mypicture.Save	( myjpg );
					mycache.Cache	( thmbpath );
				}
			}
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewAssaultShots::Load", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewAssaultShots::Load", "unknown" );
	}

}

// --------------------------------------------------------------------
// public:		Try answering a question
// --------------------------------------------------------------------
bool	CPreviewAssaultShots::Answer	( const char * aQ ) const {
	if		( ! ::strcmp( aQ, "brfnshottn" ) )	{ ::printf( "%s", itsThumbnail[itsShotIdx] ); return true; }
	else if	( ! ::strcmp( aQ, "brfnshotix" ) )	{ ::printf( "%d", itsShotIdx ); return true; }
	else if	( ! ::strcmp( aQ, "brfnshot" ) )	{ ::printf( "%s", itsDetailShot ); return true; }
	else if	( ! ::strcmp( aQ, "brfntext" ) )	{ ::printf( "%s", itsBriefing[itsShotIdx] ); return true; }
	else if	( ! ::strcmp( aQ, "imageurl" ) )	{ ::printf( "%s", itsBaseUrl ); return true; }

	return	false;
}

// --------------------------------------------------------------------
// private		Free data
// --------------------------------------------------------------------
void	CPreviewAssaultShots::Free	( void ) {
	int	i;
	for	( i = 0; i < MAX_ASSAULTSHOT; i++ ) {
		if	( itsBriefing[i] ) delete [] itsBriefing[i];
	}
	CPreviewAssaultShots::Cleanup();
}

// --------------------------------------------------------------------
// private		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewAssaultShots::Cleanup	( void ) {
	::memset( itsBriefing,		0, sizeof( itsBriefing ) );
	::memset( itsThumbnail,		0, sizeof( itsThumbnail ) );
	::memset( itsDetailShot,	0, sizeof( itsDetailShot ) );
	::memset( itsBaseUrl,		0, sizeof( itsBaseUrl ) );
	::memset( itsBasePath,		0, sizeof( itsBasePath ) );
	itsShotIdx		= 0;
	itsShotCount	= 0;
}

// --------------------------------------------------------------------
// EOF:	CPreviewAssaultShots.cxx
// --------------------------------------------------------------------
