// --------------------------------------------------------------------
// CPreviewLeafMenu.cxx
// Whatis:	Template executor
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewLeafMenu.hxx"
#include	"CTableFile.hxx"
#include	"CTableType.hxx"
#include	"CTableRule.hxx"
#include	"CMySqlWhere.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewLeafMenu::CPreviewLeafMenu ( void ) {
	CPreviewLeafMenu::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewLeafMenu::~CPreviewLeafMenu ( void ) {
	CPreviewLeafMenu::Free();
}

// --------------------------------------------------------------------
// public:		Load leaf menu data
// --------------------------------------------------------------------
void	CPreviewLeafMenu::Load(	dword_t		aFileIdnt,
								int			aLeafIdnt ) {
	try	{
		CMySqlConnect	db( "quest", "", "UTCMS" );
		CMySqlWhere		w;
		CTableFile		tfile;
		CTableType		ttype;
		CTableRule		trule;
		data_file_tl	lfile;
		data_type_tl	ltype;
		data_rule_tl	lrule;

		// Set my idnt
		itsLeafNow = aLeafIdnt;

		// File information
		w << "file_idnt=" << aFileIdnt;
		lfile = tfile.Select( db, w );
		if	( lfile.size() < 1 ) {
			throw CError( w.Where(), "No such file" );
		}

		// Type information
		w = "";
		w << "type_idnt=" << (*(lfile.begin())).file_type;
		ltype = ttype.Select( db, w );
		if	( ltype.size() < 1 ) {
			throw CError( w.Where(), "No such type" );
		}

		// Rule information
		w = "";
		w << "rule_type=" << (*(lfile.begin())).file_type << " and rule_name='pvmeth'";
		lrule = trule.Select( db, w );


		// Is the file downloadable ?
		itsLeafUsage[LEAFMENU_DOWNLOAD]	= ((*(lfile.begin())).file_flag & FLAG_NODOWNLOAD) == 0;

		// We can always find similar files
		itsLeafUsage[LEAFMENU_SIMILAR]		= true;

		// Files always have file details
		itsLeafUsage[LEAFMENU_FILEDETAILS]	= true;

		// Rest of the flags are rule dependant
		if	( lrule.size() > 0 ) {
			itsLeafUsage[LEAFMENU_SCREENSHOTS]	= (::strchr( (*(lrule.begin())).rule_rule, 'l' ) != NULL);
			itsLeafUsage[LEAFMENU_ASSBRIEFINGS]	= (::strchr( (*(lrule.begin())).rule_rule, 'a' ) != NULL);
			itsLeafUsage[LEAFMENU_LEVELINFO]	= (::strchr( (*(lrule.begin())).rule_rule, 'l' ) != NULL);
			itsLeafUsage[LEAFMENU_UNRDETAILS]	= (::strchr( (*(lrule.begin())).rule_rule, 'u' ) != NULL);
			itsLeafUsage[LEAFMENU_IMPORTLIST]	= (::strchr( (*(lrule.begin())).rule_rule, 'u' ) != NULL);
			itsLeafUsage[LEAFMENU_EXPORTLIST]	= (::strchr( (*(lrule.begin())).rule_rule, 'u' ) != NULL);
			itsLeafUsage[LEAFMENU_TEXTCONTENT]	= (::strchr( (*(lrule.begin())).rule_rule, 't' ) != NULL);
			itsLeafUsage[LEAFMENU_IMAGECONTENT]	= (::strchr( (*(lrule.begin())).rule_rule, 'i' ) != NULL);
			itsLeafUsage[LEAFMENU_RENDERFRONT]	=
			itsLeafUsage[LEAFMENU_RENDERLEFT]	=
			itsLeafUsage[LEAFMENU_RENDERTOP]	= ( aLeafIdnt == LEAFMENU_RENDERCONTENT );
			itsLeafUsage[LEAFMENU_RENDERCONTENT]= (::strchr( (*(lrule.begin())).rule_rule, 'r' ) != NULL);
			itsLeafUsage[LEAFMENU_TEXTURES]		= ( (::strchr( (*(lrule.begin())).rule_rule, 'x' ) != NULL) || ( aLeafIdnt == LEAFMENU_TEXTURES) );
			itsLeafUsage[LEAFMENU_SKIN]			= (::strchr( (*(lrule.begin())).rule_rule, 's' ) != NULL);
		}
	}

	catch	( CError e ) {
		throw	CError( "CPreviewLeafMenu::Load", e.Error() );
	}

	catch	( ... ) {
		throw	CError( "CPreviewLeafMenu::Load", "unknown" );
	}

}

// --------------------------------------------------------------------
// public:		Answer the parser
// --------------------------------------------------------------------
bool	CPreviewLeafMenu::Answer( const char * aQ ) const {
	try {
		dword_t	argnum;
		char	argname [32];

		for	( argnum = 0; argnum < LEAFMENU_COUNT; argnum++ ) {
			::sprintf( argname, "use_leaf%d_b", argnum );
			if	( ! ::strcmp( aQ, argname ) ) {
				::printf( "%s", itsLeafUsage[argnum] ? "" : "<!-- " );
				return true;
			}

			::sprintf( argname, "use_leaf%d_e", argnum );
			if	( ! ::strcmp( aQ, argname ) ) {
				::printf( "%s", itsLeafUsage[argnum] ? "" : " -->" );
				return true;
			}

			::sprintf( argname, "set_leaf%d?", argnum );
			if	( ! ::strncmp( aQ, argname, ::strlen( argname ) ) ) {
				const char *	q = aQ + strlen( argname );

				if	( itsLeafNow == (int)argnum ) {
					while	( ( *q ) && ( *q != ':' ) ) {
						::putchar( *(q++) );
					}
				}
				else {
					q = ::strchr( q, ':' );
					if	( q ) {
						::printf( "%s", q + 1 );
					}
				}
				return true;
			}
		}
	}

	catch	( CError e ) {
		throw	CError( "CPreviewLeafMenu::Load", e.Error() );
	}

	catch	( ... ) {
		throw	CError( "CPreviewLeafMenu::Load", "unknown" );
	}

	return	false;
}

// --------------------------------------------------------------------
// private:		Free data
// --------------------------------------------------------------------
void	CPreviewLeafMenu::Free ( void ) {
	CPreviewLeafMenu::Cleanup();
}

// --------------------------------------------------------------------
// private:		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewLeafMenu::Cleanup ( void ) {
	int		i;
	itsLeafNow	= 0;
	for	( i = 0; i < LEAFMENU_COUNT; i++ ) {
		itsLeafUsage[i] = false;
	}
}

// --------------------------------------------------------------------
// EOF:	CPreviewLeafMenu.cxx
// --------------------------------------------------------------------
