// --------------------------------------------------------------------
// CPreviewLevelInfo.cxx
// Whatis:	Screenshot preview system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewLevelInfo.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewLevelInfo::CPreviewLevelInfo ( void ) {
	CPreviewLevelInfo::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewLevelInfo::~CPreviewLevelInfo ( void ) {
	CPreviewLevelInfo::Free();
}

// --------------------------------------------------------------------
// public:		Load the information
// --------------------------------------------------------------------
void	CPreviewLevelInfo::Load	( const char * 	aUnrFile ) {
	try	{
		CPreviewLevelInfo::Free();
		CUnFile			f( aUnrFile );
		CUnNameTable	n( f );
		CUnImportTable	i( f );
		CUnExportTable	e( f );
		itsLevelInfo = new CUnLevelInfo( f, n, e, i );
	}

	catch	( CError e ) {
		throw CError( "CPreviewLevelInfo::Load", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewLevelInfo::Load", "unknown" );
	}

}

// --------------------------------------------------------------------
// public:		Try answering a question
// --------------------------------------------------------------------
bool	CPreviewLevelInfo::Answer	( const char * aQ ) const {

	// ----------------------------------------------------------------
	// Extracting data from level info
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "lvl-author" ) )		{ ::HTML_quote( itsLevelInfo->Author() ); return true; }
	else if	( ! ::strcmp( aQ, "lvl-title" ) )		{ ::HTML_quote( itsLevelInfo->Title() ); return true; }
	else if	( ! ::strcmp( aQ, "lvl-enter" ) )		{ ::HTML_quote( itsLevelInfo->EnterText() ); return true; }
	else if	( ! ::strcmp( aQ, "lvl-ideal" ) )		{ ::HTML_quote( itsLevelInfo->IdealPlayers() ); return true; }
	else if	( ! ::strcmp( aQ, "lvl-sscount" ) )		{ ::printf( "%d", itsLevelInfo->ShotCount() ); return true; }

	return	false;
}

// --------------------------------------------------------------------
// private		Free data
// --------------------------------------------------------------------
void	CPreviewLevelInfo::Free	( void ) {
	if	( itsLevelInfo )	delete itsLevelInfo;
	CPreviewLevelInfo::Cleanup();
}

// --------------------------------------------------------------------
// private		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewLevelInfo::Cleanup	( void ) {
	itsLevelInfo = NULL;
}

// --------------------------------------------------------------------
// EOF:	CPreviewLevelInfo.cxx
// --------------------------------------------------------------------
