// --------------------------------------------------------------------
// CPreviewScore.cxx
// Whatis:	File score preview system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewScore.hxx"
#include	"CMySqlWhere.hxx"
#include	"CScore.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewScore::CPreviewScore ( void ) {
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewScore::~CPreviewScore ( void ) {
}

// --------------------------------------------------------------------
// public:		Try answering a question
// --------------------------------------------------------------------
bool	CPreviewScore::Answer	(	const data_file_t &		aFd,
									const CCgiArgs &		aCgi,
									const char *			aQ,
									CMySqlConnect & 		aDb ) {

	// ----------------------------------------------------------------
	// What type of score was requested
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "badscore" ) )	return	CPreviewScore::BadScore( aFd );
	else if	( ! ::strcmp( aQ, "avgscore" ) )	return	CPreviewScore::AvgScore( aFd );
	else if	( ! ::strcmp( aQ, "godscore" ) )	return	CPreviewScore::GodScore( aFd );
	else if	( ! ::strcmp( aQ, "badstate" ) )	return	CPreviewScore::BadState( aFd, aCgi, aDb );
	else if	( ! ::strcmp( aQ, "avgstate" ) )	return	CPreviewScore::AvgState( aFd, aCgi, aDb );
	else if	( ! ::strcmp( aQ, "godstate" ) )	return	CPreviewScore::GodState( aFd, aCgi, aDb );
	return	false;
}

// --------------------------------------------------------------------
bool	CPreviewScore::GodScore	( const data_file_t & aFd )	const {
	CScore	score( aFd );
	::printf(	"%s%s%d",
				score.God() < 100 ? "0" : "",
				score.God() < 10  ? "0" : "",
				score.God() );
	return true;
}

// --------------------------------------------------------------------
bool	CPreviewScore::AvgScore	( const data_file_t & aFd )	const {
	CScore	score( aFd );
	::printf(	"%s%s%d",
				score.Avg() < 100 ? "0" : "",
				score.Avg() < 10  ? "0" : "",
				score.Avg() );
	return true;
}

// --------------------------------------------------------------------
bool	CPreviewScore::BadScore	( const data_file_t & aFd )	const {
	CScore	score( aFd );
	::printf(	"%s%s%d",
				score.Bad() < 100 ? "0" : "",
				score.Bad() < 10  ? "0" : "",
				score.Bad() );
	return true;
}

// --------------------------------------------------------------------
bool	CPreviewScore::GodState	( const data_file_t & aFd, const CCgiArgs & aCgi, CMySqlConnect & aDb ) {
	CMySqlWhere		w;
	CMySqlQuote		q;

	w 	<< "vote_idnt='"
		<< aFd.file_idnt
		<< "-2-"
		<< q.Quote( aCgi.Arg( CGI_REMOTE_ADDR ) )
		<< "'";

	if	( itsVote.Count( aDb, w ) > 0 )	::printf( "1" );
	else								::printf( "0" );

	return true;
}

// --------------------------------------------------------------------
bool	CPreviewScore::AvgState	( const data_file_t & aFd, const CCgiArgs & aCgi, CMySqlConnect & aDb ) {
	CMySqlWhere		w;
	CMySqlQuote		q;

	w 	<< "vote_idnt='"
		<< aFd.file_idnt
		<< "-1-"
		<< q.Quote( aCgi.Arg( CGI_REMOTE_ADDR ) )
		<< "'";

	if	( itsVote.Count( aDb, w ) > 0 )	::printf( "1" );
	else								::printf( "0" );

	return true;
}

// --------------------------------------------------------------------
bool	CPreviewScore::BadState	( const data_file_t & aFd, const CCgiArgs & aCgi, CMySqlConnect & aDb ) {
	CMySqlWhere		w;
	CMySqlQuote		q;

	w 	<< "vote_idnt='"
		<< aFd.file_idnt
		<< "-0-"
		<< q.Quote( aCgi.Arg( CGI_REMOTE_ADDR ) )
		<< "'";

	if	( itsVote.Count( aDb, w ) > 0 )	::printf( "1" );
	else								::printf( "0" );

	return true;
}

// --------------------------------------------------------------------
// EOF:	CPreviewScore.cxx
// --------------------------------------------------------------------
