// --------------------------------------------------------------------
// CPreviewSkin.cxx
// Whatis:	Skin preview system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewSkin.hxx"
#include	"CPreviewFile.hxx"
#include	"CError.hxx"
#include	"CCache.hxx"
#include	"CStorage.hxx"
#include	"CPicture.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CPictureFilterAlphaBlend.hxx"
#include	"CFurpileLogo.hxx"
#include	"CTablePackFile.hxx"
#include	"CUnUtils.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewSkin::CPreviewSkin ( void ) {
	CPreviewSkin::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewSkin::~CPreviewSkin ( void ) {
	CPreviewSkin::Free();
}

// --------------------------------------------------------------------
// public:		Load the information
// --------------------------------------------------------------------
void	CPreviewSkin::Load	( dword_t aFileIdnt ) {
	try	{
		CPreviewSkin::Free();

		// Get the UPL file
		CPreviewFile	myuplfile;

		myuplfile.Load( aFileIdnt, true );
		itsFileData = myuplfile.File();

		if	( ::strcmp( itsFileData.file_typ2, "UPL" ) ) {
			throw CError( itsFileData.file_name, "Not a player declaration" );
		}

		// Parse the UPL file into our data
		CPreviewSkin::ParseUPL( myuplfile.FilePath() );

		// Preload the portrait
		CPreviewSkin::PreloadPortrait( );

	}

	catch	( CError e ) {
		throw CError( "CPreviewSkin::Load", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewSkin::Load", "unknown" );
	}

}

// --------------------------------------------------------------------
// public:		Try answering a question
// --------------------------------------------------------------------
bool	CPreviewSkin::Answer	( const char * aQ ) const {
	if		( ! ::strcmp( aQ, "DefaultName" ) )		{ ::HTML_quote( itsDefaultName		[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Mesh" ) )			{ ::HTML_quote( itsMesh				[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Species" ) )			{ ::HTML_quote( itsSpecies			[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Portrait" ) )		{ ::HTML_quote( itsPortrait			[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Text" ) )			{ ::HTML_quote( itsText				[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Sex" ) )				{ ::HTML_quote( itsSex				[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "BodySkin" ) )		{ ::HTML_quote( itsBodySkin			[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "FaceSkin" ) )		{ ::HTML_quote( itsFaceSkin			[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Menu" ) )			{ ::HTML_quote( itsMenu				[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Aggressiveness" ) )	{ ::HTML_quote( itsAggressiveness	[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "CombatStyle" ) )		{ ::HTML_quote( itsCombatStyle		[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "FavoriteWeapon" ) )	{ ::HTML_quote( itsFavoriteWeapon	[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Tactics" ) )			{ ::HTML_quote( itsTactics			[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "StrafingAbility" ) )	{ ::HTML_quote( itsStrafingAbility	[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "Accuracy" ) )		{ ::HTML_quote( itsAccuracy			[itsSkinIndex] ); return true; }
	else if	( ! ::strcmp( aQ, "PortraitUrl" ) )		{ ::printf( "%s", itsPortraitUrl	[itsSkinIndex] ); return true; }

	return	false;
}

// --------------------------------------------------------------------
// private		Parse the UPL data
// --------------------------------------------------------------------
void	CPreviewSkin::ParseUPL	( const char * aUplFile ) {
	char	linebuf[2048];
	FILE *	strm = NULL;
	try	{
		strm = ::fopen( aUplFile, "r" );
		if	( ! strm ) throw CError( aUplFile, ::strerror( errno ) );

		// Parse through all player= entries
		while	( itsSkinCount < MAX_SKIN_COUNT ) {

			*linebuf = 0;
			while	( ::fgets( linebuf, sizeof( linebuf ) - 1, strm ) ) {
				::my_strfix( linebuf );
				if	( ::strncmp( linebuf, "Player=(", 8 ) )	continue;

				// Remove the enter thing
				::strcpy( linebuf, linebuf + 8 );

				// Remove any embedded spaces
				char *	sp = ::strchr( linebuf, ' ' );
				while	( sp ) {
					::strcpy( sp, sp + 1 );
					sp = ::strchr( linebuf, ' ' );
				}

				// Remove terminating ')'
				sp = ::strchr( linebuf, ')' );
				if	( ! sp )	continue;
				*sp = 0;
				break;
			}
			::my_strfix( linebuf );

			// Errors ?
			if	( ferror( strm ) ) {
				throw CError( aUplFile, ::strerror( errno ) );
			}

			// Any luck with the line ?
			if	( *linebuf == 0 ) {
				if	( itsSkinCount == 0 )	throw CError( aUplFile, "Unable to interpret" );
				else						break;
			}

			// Interpret contents of the line
			char	*	s = linebuf;
			char	*	e;
			char	*	pn;
			char	*	pv;
	
			while	( s ) {

				// Name of the parameter
				pn = s;
				e = ::strchr( s, '=' );
				if	( ! e )	break;
				*e = 0;	s = e + 1;
	
				// Value of the parameter
				pv = s;
				e = ::strchr( s, ',' );
				if	( e ) 	{ *e = 0;	s = e + 1; }
				else		{ s = NULL; }
	
				// So, let's see if we know it !
				if		( ! ::strcmp( pn, "DefaultName" ) )		::my_strfit( itsDefaultName		[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Mesh" ) )			::my_strfit( itsMesh			[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Species" ) )			::my_strfit( itsSpecies			[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Portrait" ) )		::my_strfit( itsPortrait		[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Text" ) )			::my_strfit( itsText			[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Sex" ) )				::my_strfit( itsSex				[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "BodySkin" ) )		::my_strfit( itsBodySkin		[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "FaceSkin" ) )		::my_strfit( itsFaceSkin		[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Menu" ) )			::my_strfit( itsMenu			[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Aggressiveness" ) )	::my_strfit( itsAggressiveness	[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "CombatStyle" ) )		::my_strfit( itsCombatStyle		[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "FavoriteWeapon" ) )	::my_strfit( itsFavoriteWeapon	[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Tactics" ) )			::my_strfit( itsTactics			[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "StrafingAbility" ) )	::my_strfit( itsStrafingAbility	[itsSkinCount], 128, pv );
				else if	( ! ::strcmp( pn, "Accuracy" ) )		::my_strfit( itsAccuracy		[itsSkinCount], 128, pv );
			}
			itsSkinCount++;
		}
		::fclose( strm );
		strm = NULL;

	}

	catch	( CError e ) {
		if	( strm ) ::fclose( strm );
		throw CError( "CPreviewSkin::ParseUPL", e.Error() );
	}

	catch	( ... ) {
		if	( strm ) ::fclose( strm );
		throw CError( "CPreviewSkin::ParseUPL", "unknown" );
	}

}

// --------------------------------------------------------------------
// private		Preload the portrait
// --------------------------------------------------------------------
void	CPreviewSkin::PreloadPortrait ( void ) {
	try {
		dword_t				skix;
		CCache				pvcache( "preview" );
		CMySqlConnect		db( "quest", "", "UTCMS" );
		CTablePackFile		packfile;
		CTableFile			file;

		for	( skix = 0; skix < itsSkinCount; skix++ ) {
			char	portpack	[128];
			char	portname	[128];
			dword_t	packidnt	= 0;
			char *	p;

			// Extract the portrait package and name
			p = ::strchr( itsPortrait[skix], '.' );
			if	( ! p ) throw CError( itsPortrait[skix], "Missing separator" );

			*p = 0;
			::strcpy( portpack, itsPortrait[skix] );
			if	( ::strchr( p + 1, '.' ) )	::strcpy( portname, ::strchr( p + 1, '.' ) + 1 );
			else							::strcpy( portname, p + 1 );
			*p = '.';

			// Find the texture file for the portrait
			data_file_tl		flist;
			data_file_t			filedata;
			data_packfile_tl	pflist1;
			data_packfile_tl	pflist2;
			data_packfile_tli	pfloop1;
			data_packfile_tli	pfloop2;
			CMySqlWhere			w;
			CMySqlQuote			q;

			// First, get packages that have this file in them
			w << "packfile_file=" << itsFileData.file_idnt;
			pflist1 = packfile.Select( db, w );

			// With the packs, get a list of file identifiers
			for	( pfloop1 = pflist1.begin(); pfloop1 != pflist1.end(); pfloop1++ ) {
				w = "";
				w << "packfile_pack=" << (*pfloop1).packfile_pack;
				pflist2 = packfile.Select( db, w );
	
				// With the file identifiers try to locate the desired package
				for	( pfloop2 = pflist2.begin(); pfloop2 != pflist2.end(); pfloop2++ ) {
					w = "";
					w << "file_idnt=" << (*pfloop2).packfile_file << " and ";
					w << "file_name='" << q.Quote( portpack ) << "' and ";
					w << "(file_typ2='UTX' or file_typ2='UT2K3-UTX')";
					if	( file.Count( db, w ) > 0 ) {
						packidnt = (*pfloop2).packfile_file;
						break;
					}
				}
				if	( packidnt )	break;
			}

			// Did we locate the pack ?
			if	( packidnt == 0 )	throw CError( portpack, "Package not found" );

			// Load the texture file
			w = "";
			w << "file_idnt=" << packidnt;
			flist = file.Select( db, w );
			if	( flist.size() == 0 )	throw CError( portpack, "File missing from system" );
			filedata = *(flist.begin());

			// Load the UTX file
			char	prevfile[1024];
			char	filepath[1024];

			::sprintf( 	prevfile, "%d-file.%s",
						filedata.file_idnt,
						filedata.file_suff );

			pvcache.MakeDirname( filepath, prevfile );
			if	( ! pvcache.Exist( filepath ) ) {
				CStorage	storage;
				storage.Load( filepath, filedata.file_idnt );
				pvcache.Cache( filepath );
			}

			CUnUtils	unrutils( filepath );

			unr_actor_tl	ulist = unrutils.ActorList( "Texture" );
			unr_actor_tli	uloop;

			// Loop through the list searching for teh texture
			for	( uloop = ulist.begin(); uloop != ulist.end(); uloop++ ) {
				if	( ! ::my_stricmp( (*uloop).name, portname ) ) break;
			}
			if	( uloop == ulist.end() ) {
				for	( uloop = ulist.begin(); uloop != ulist.end(); uloop++ ) {
					if	( ! ::my_stricmp( (*uloop).name, "screenshot" ) ) break;
				}
			}
			if	( uloop == ulist.end() )	throw CError( portname, "Texture not found" );

			// Now that we have grip on the texture
			::sprintf(	prevfile, "%d-texture-%s.jpg",
						filedata.file_idnt,
						portname );
			pvcache.MakeDirname( filepath, prevfile );
			if	( ! pvcache.Exist( filepath ) ) {
				unrutils.Seek( *uloop );
				CUnTexture			mytexture( 	unrutils.UnFile(),
												unrutils.UnNameTable(),
												unrutils.UnExportTable(),
												unrutils.UnImportTable() );
				CPicture			mypicture;
				CPictureSourceUTX	myutx( &mytexture );
				CPictureSourceJPG	myjpg( filepath, 70 );
				CFurpileLogo		logo( "Furpile.utx" );
				CPictureFilterAlphaBlend	alphablend( 0x1b, 0x00, 0x3e, 0xff );
		
				mypicture.Load	( myutx );
				mypicture.Filter( alphablend );
				logo.Plant( mypicture.PixmapRef() );
				mypicture.Save	( myjpg );
				pvcache.Cache	( filepath );
			}
	
			// Finally set up the URL
			::sprintf( itsPortraitUrl[skix], "%s/%s", pvcache.UrlBase(), prevfile );
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewSkin::PreloadPortrait", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewSkin::PreloadPortrait", "unknown" );
	}
}

// --------------------------------------------------------------------
// private		Free data
// --------------------------------------------------------------------
void	CPreviewSkin::Free	( void ) {
	CPreviewSkin::Cleanup();
}

// --------------------------------------------------------------------
// private		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewSkin::Cleanup	( void ) {
	itsSkinCount 	= 0;
	itsSkinIndex	= 0;
	::memset( itsPortraitUrl	, 0, sizeof( itsPortraitUrl		 ) );
	::memset( itsDefaultName	, 0, sizeof( itsDefaultName		 ) );
	::memset( itsMesh			, 0, sizeof( itsMesh			 ) );
	::memset( itsSpecies		, 0, sizeof( itsSpecies			 ) );
	::memset( itsPortrait		, 0, sizeof( itsPortrait		 ) );
	::memset( itsText			, 0, sizeof( itsText			 ) );
	::memset( itsSex			, 0, sizeof( itsSex				 ) );
	::memset( itsBodySkin		, 0, sizeof( itsBodySkin		 ) );
	::memset( itsFaceSkin		, 0, sizeof( itsFaceSkin		 ) );
	::memset( itsMenu			, 0, sizeof( itsMenu			 ) );
	::memset( itsAggressiveness	, 0, sizeof( itsAggressiveness	 ) );
	::memset( itsCombatStyle	, 0, sizeof( itsCombatStyle		 ) );
	::memset( itsFavoriteWeapon	, 0, sizeof( itsFavoriteWeapon	 ) );
	::memset( itsTactics		, 0, sizeof( itsTactics			 ) );
	::memset( itsStrafingAbility, 0, sizeof( itsStrafingAbility	 ) );
	::memset( itsAccuracy		, 0, sizeof( itsAccuracy		 ) );
}

// --------------------------------------------------------------------
// EOF:	CPreviewSkin.cxx
// --------------------------------------------------------------------
