// --------------------------------------------------------------------
// CPreviewTemplate.cxx
// Whatis:	Template executor
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewTemplate.hxx"
#include	"CTablePref.hxx"
#include	"CMySqlWhere.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewTemplate::CPreviewTemplate ( void ) {
	CPreviewTemplate::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewTemplate::~CPreviewTemplate ( void ) {
	CPreviewTemplate::Free();
}

// --------------------------------------------------------------------
// public:		Execute one template
// --------------------------------------------------------------------
void	CPreviewTemplate::Execute(	parse_ask_fun_tp	aCallback,
									const char *		aTemplateName ) {
	try	{
		::my_parse( aCallback, CPreviewTemplate::Cache( aTemplateName ) );

	}
	catch	( CError e ) {
		throw	CError( "CPreviewTemplate::Execute", e.Error() );
	}
	catch	( ... ) {
		throw	CError( "CPreviewTemplate::Execute", "unknown" );
	}
}

// --------------------------------------------------------------------
// private:		Free data
// --------------------------------------------------------------------
void	CPreviewTemplate::Free ( void ) {
	int	i;
	for	( i = 0; i < MAX_TEMPLATES; i++ ) {
		if	( itsCacheName[i] )	delete [] itsCacheName[i];
		if	( itsCacheData[i] )	delete [] itsCacheData[i];
	}
	CPreviewTemplate::Cleanup();
}

// --------------------------------------------------------------------
// private:		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewTemplate::Cleanup ( void ) {
	int	i;
	for	( i = 0; i < MAX_TEMPLATES; i++ ) {
		itsCacheName[i]	= NULL;
		itsCacheData[i]	= NULL;
	}
}

// --------------------------------------------------------------------
// private:		Cache a given template
// --------------------------------------------------------------------
const char *	CPreviewTemplate::Cache ( const char * aTemplateName ) {
	int		i;

	// Is this in cache ?
	for	( i = 0; i < MAX_TEMPLATES; i++ ) {
		if	( itsCacheName[i] == NULL )	break;
		if	( ! ::strcmp( aTemplateName, itsCacheName[i] ) ) {
			return	itsCacheData[i];
		}
	}

	// Too many already cached
	if	( i >= MAX_TEMPLATES )	return	"";

	// Cache this one
	try	{
		CMySqlConnect	db( "quest", "", "UTCMS" );
		CTablePref		pref;
		data_pref_tl	list;
		CMySqlWhere		w;

		w << "pref_name='" << aTemplateName << "'";
		list = pref.Select( db, w );

		if	( list.size() < 1 ) {
			throw CError( aTemplateName, "Preference not found" );
		}
		itsCacheData[i] = ::my_load_file( (*(list.begin())).pref_valu );
		itsCacheName[i] = ::my_private_strdup( aTemplateName );
	}

	catch	( CError e ) {
		if	( itsCacheData[i] ) delete [] itsCacheData[i];
		if	( itsCacheName[i] ) delete [] itsCacheName[i];
		itsCacheName[i] = NULL;
		itsCacheData[i] = NULL;
		throw	CError( "CPreviewTemplate::Cache", e.Error() );
	}

	catch	( ... ) {
		if	( itsCacheData[i] ) delete [] itsCacheData[i];
		if	( itsCacheName[i] ) delete [] itsCacheName[i];
		itsCacheName[i] = NULL;
		itsCacheData[i] = NULL;
		throw	CError( "CPreviewTemplate::Cache", "unknown" );
	}

	return	itsCacheData[i];
}

// --------------------------------------------------------------------
// EOF:	CPreviewTemplate.cxx
// --------------------------------------------------------------------
