// --------------------------------------------------------------------
// CPreviewText.cxx
// Whatis:	Session manipulation
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CCache.hxx"
#include	"CStorage.hxx"
#include	"CPreviewText.hxx"
#include	"CMySqlWhere.hxx"
#include	"CTableFile.hxx"

// --------------------------------------------------------------------
// local:		IsSpace macro
// --------------------------------------------------------------------
#define	MyIsSpace(c)	(((c)>0)&&((c)<=' ')&&((c)!='\n')&&((c)!='\r')&&((c)!='\t'))

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewText::CPreviewText ( void ) {
	CPreviewText::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewText::~CPreviewText ( void ) {
	CPreviewText::Free();
}

// --------------------------------------------------------------------
// public:		Output some raw information
// --------------------------------------------------------------------
void	CPreviewText::OutputRaw	( dword_t aFileIdnt ) {
	char *	textbuff = NULL;

	try	{
		textbuff = CPreviewText::LoadFile( aFileIdnt );
		::printf( "%s", textbuff );
		delete [] textbuff;
	}

	catch	( CError e ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputRaw", e.Error() );
	}

	catch	( ... ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputRaw", "unknown" );
	}
}

// --------------------------------------------------------------------
// public:		Output HTML encoded
// --------------------------------------------------------------------
void	CPreviewText::OutputHttp		( dword_t aFileIdnt ) {
	char *	textbuff = NULL;

	try	{
		char *	p = textbuff = CPreviewText::LoadFile( aFileIdnt );

		while	( *p ) {
			if	( ( p[0] == ' ' ) && ( p[1] == ' ' ) )	::printf( "%s", "&nbsp;" );
			else										::HTML_quotec( *p );
			p++;
		}
		delete [] textbuff;
	}

	catch	( CError e ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputHttp", e.Error() );
	}

	catch	( ... ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputHttp", "unknown" );
	}
}

// --------------------------------------------------------------------
// public:		Output HTML encoded - use file pointer and size
// --------------------------------------------------------------------
void	CPreviewText::OutputHttp		( 	FILE *	aStrm,
											dword_t	aSize ) {
	char *	textbuff = NULL;

	try	{
		char *	p = textbuff = new char [aSize + 1];

		::fread( textbuff, aSize, 1, aStrm );
		textbuff[aSize] = 0;

		while	( *p ) {
			if	( ( p[0] == ' ' ) && ( p[1] == ' ' ) )	::printf( "%s", "&nbsp;" );
			else										::HTML_quotec( *p );
			p++;
		}
		delete [] textbuff;
	}

	catch	( CError e ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputHttp", e.Error() );
	}

	catch	( ... ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputHttp", "unknown" );
	}
}

// --------------------------------------------------------------------
// public:		Output HTML encoded + <br>
// --------------------------------------------------------------------
void	CPreviewText::OutputHttpBr	( dword_t aFileIdnt ) {
	char *	textbuff = NULL;

	try	{
		char *	p = textbuff = CPreviewText::LoadFile( aFileIdnt );

		while	( *p ) {
			if		( p[0] == '\n' )		::printf( "%s", "\n" );
			else							::HTML_quotec( *p );
			p++;
		}
		delete [] textbuff;
	}

	catch	( CError e ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputHttpBr", e.Error() );
	}

	catch	( ... ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputHttpBr", "unknown" );
	}
}

// --------------------------------------------------------------------
// public:		Output HTML encoded + UBB code
// --------------------------------------------------------------------
void	CPreviewText::OutputUBB		( dword_t aFileIdnt ) {
	char *			textbuff = NULL;
	const char *	p;

	try	{
		p = textbuff = CPreviewText::LoadFile( aFileIdnt );
		while	( *p )	p = CPreviewText::UbbParse( p );
		delete [] textbuff;
	}

	catch	( CError e ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputUBB", e.Error() );
	}

	catch	( ... ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::OutputUBB", "unknown" );
	}
}

// --------------------------------------------------------------------
// private:		UBB main parser
// --------------------------------------------------------------------
const char *	CPreviewText::UbbParse	( const char *	aP ) {

	while	( *aP ) {
		if		( ! ::strncmp( aP, "[b]",	 	3 ) )	aP = CPreviewText::UbbParseBUI( aP + 3, "[/b]", "b" );
		else if	( ! ::strncmp( aP, "[/b]",	 	4 ) )	return	aP + 4;

		else if	( ! ::strncmp( aP, "[u]",	 	3 ) )	aP = CPreviewText::UbbParseBUI( aP + 3, "[/u]", "u" );
		else if	( ! ::strncmp( aP, "[/u]",	 	4 ) )	return	aP + 4;

		else if	( ! ::strncmp( aP, "[i]",	 	3 ) )	aP = CPreviewText::UbbParseBUI( aP + 3, "[/i]", "i" );
		else if	( ! ::strncmp( aP, "[/i]",	 	4 ) )	return	aP + 4;

		else if	( ! ::strncmp( aP, "[center]",	8 ) )	aP = CPreviewText::UbbParseBUI( aP + 8, "[/center]", "center" );
		else if	( ! ::strncmp( aP, "[/center]",	9 ) )	return	aP + 9;

		else if	( ! ::strncmp( aP, "[border]",	8 ) )	aP = CPreviewText::UbbParseBorder( aP + 8 );
		else if	( ! ::strncmp( aP, "[/border]",	9 ) )	return	aP + 9;

		else if	( ! ::strncmp( aP, "[img]",	 	5 ) )	aP = CPreviewText::UbbParseImg( aP + 5 );
		else if	( ! ::strncmp( aP, "[/img]", 	6 ) )	return	aP + 6;

		else if	( ! ::strncmp( aP, "[html]", 	6 ) )	aP = CPreviewText::UbbParseHtml( aP + 6 );
		else if	( ! ::strncmp( aP, "[/html]", 	7 ) )	return	aP + 7;

		else if	( ! ::strncmp( aP, "[email]", 	7 ) )	aP = CPreviewText::UbbParseLink( aP + 6, "[/email]", "mailto:", "_blank" );
		else if	( ! ::strncmp( aP, "[email=", 	7 ) )	aP = CPreviewText::UbbParseLink( aP + 6, "[/email]", "mailto:", "_blank" );
		else if	( ! ::strncmp( aP, "[/email]", 	8 ) )	return	aP + 8;

		else if	( ! ::strncmp( aP, "[url]", 	5 ) )	aP = CPreviewText::UbbParseLink( aP + 4, "[/url]", "", "_blank" );
		else if	( ! ::strncmp( aP, "[url=", 	5 ) )	aP = CPreviewText::UbbParseLink( aP + 4, "[/url]", "", "_blank" );
		else if	( ! ::strncmp( aP, "[/url]", 	6 ) )	return	aP + 6;

		else if	( ! ::strncmp( aP, "[lurl]", 	6 ) )	aP = CPreviewText::UbbParseLink( aP + 5, "[/lurl]", "", "_self" );
		else if	( ! ::strncmp( aP, "[lurl=", 	6 ) )	aP = CPreviewText::UbbParseLink( aP + 5, "[/lurl]", "", "_self" );
		else if	( ! ::strncmp( aP, "[/lurl]", 	7 ) )	return	aP + 7;

		else if	( ! ::strncmp( aP, "[color=", 	7 ) )	aP = CPreviewText::UbbParseFont( aP + 7, "[/color]", "color" );
		else if	( ! ::strncmp( aP, "[/color]", 	8 ) )	return	aP + 8;

		else if	( ! ::strncmp( aP, "[size=", 	6 ) )	aP = CPreviewText::UbbParseFont( aP + 6, "[/size]", "size" );
		else if	( ! ::strncmp( aP, "[/size]", 	7 ) )	return	aP + 7;

		else if	( ! ::strncmp( aP, "[font=", 	6 ) )	aP = CPreviewText::UbbParseFont( aP + 6, "[/font]", "font" );
		else if	( ! ::strncmp( aP, "[/font]", 	7 ) )	return	aP + 7;

		else	::HTML_quotec( *(aP++) );
	}

	return	aP;
}

// --------------------------------------------------------------------
// private:		UBB parser [b]....[/b]
// --------------------------------------------------------------------
const char *	CPreviewText::UbbParseBUI	( const char * aP, const char * aTerm, const char * aTag ) {
	dword_t	len = ::strlen( aTerm );

	::printf( "<%s>", aTag );
	do {
		aP = CPreviewText::UbbParse( aP );
		if	( *aP == 0 )	break;
		if	( ! ::strncmp( aP - len, aTerm, len ) )	break;

		for	( int i = len; i > 0; i-- )	::HTML_quotec( *(aP - i) );

	}	while ( *aP );
	::printf( "</%s>", aTag );
	return	aP;
}

// --------------------------------------------------------------------
// private:		UBB parser for links
// --------------------------------------------------------------------
const char *	CPreviewText::UbbParseLink	( const char *	aP, const char * aTerm, const char * aTag, const char * aTarg ) {
	dword_t	len = ::strlen( aTerm );

	::printf( "<a href=\"" );
	::printf( "%s", aTag );

	if	( *(aP++) == '=' ) {
		while	( ( *aP != ']' ) && ( *aP ) )	::HTML_quotec( *(aP++) );
		::printf( "\" class=\"linktext\" target=\"%s\">", aTarg );
		if	( *aP )	aP++;
		do {
			aP = CPreviewText::UbbParse( aP );
			if	( *aP == 0 )	break;
			if	( ! ::strncmp( aP - len, aTerm, len ) )	break;

			for	( int i = len; i > 0; i-- )	::HTML_quotec( *(aP - i) );

		}	while ( *aP );
	}
	else {
		const char * r	= aP;
		while	( ( *r ) && ( ::strncmp( r, aTerm, len ) ) )	::HTML_quotec( *(r++) );
		::printf( "\" class=\"linktext\" target=\"%s\">", aTarg );
		do {
			aP = CPreviewText::UbbParse( aP );
			if	( *aP == 0 )	break;
			if	( ! ::strncmp( aP - len, aTerm, len ) )	break;

			for	( int i = len; i > 0; i-- )	::HTML_quotec( *(aP - i) );

		}	while ( *aP );
	}
	::printf( "</a>" );
	return	aP;
}

// --------------------------------------------------------------------
// private:		UBB parser for font variations
// --------------------------------------------------------------------
const char *	CPreviewText::UbbParseFont( const char * aP, const char * aTerm, const char * aTag ) {
	dword_t	len = ::strlen( aTerm );

	::printf( "<font " );
	::printf( "%s", aTag );
	::printf( "%s", "=\"" );
	while	( ( *aP != ']' ) && ( *aP ) )	::HTML_quotec( *(aP++) );
	::printf( "%s", "\">" );
	if	( *aP )	aP++;
	do {
		aP = CPreviewText::UbbParse( aP );
	}	while ( ( *aP ) && ( ::strncmp( aP - len, aTerm, len ) ) );
	::printf( "</font>" );
	return	aP;
}

// --------------------------------------------------------------------
// private:		UBB parser for image
// --------------------------------------------------------------------
const char *	CPreviewText::UbbParseImg( const char * aP ) {
	::printf( "<img src=\"" );
	while	( ( *aP ) && ( ::strncmp( aP, "[/img]", 6 ) ) )	::HTML_quotec( *(aP++) );
	::printf( "\" border=\"0\">" );
	if	( *aP )	return	aP + 6;
	return aP;
}

// --------------------------------------------------------------------
// private:		UBB parser for html
// --------------------------------------------------------------------
const char *	CPreviewText::UbbParseHtml( const char * aP ) {
	while	( ( *aP ) && ( ::strncmp( aP, "[/html]", 7 ) ) )	::printf( "%c", *(aP++) );
	if	( *aP )	return	aP + 7;
	return aP;
}

// --------------------------------------------------------------------
// private:		UBB parser for border
// --------------------------------------------------------------------
const char *	CPreviewText::UbbParseBorder( const char * aP ) {
	::printf( "<table class=\"tableborder\"><tr><td><table class=\"default\"><tr><td>" );
	do {
		aP = CPreviewText::UbbParse( aP );
		if	( *aP == 0 )	break;
		if	( ! ::strncmp( aP - 9, "[/border]", 9 ) )	break;
		for	( int i = 9; i > 0; i-- )	::HTML_quotec( *(aP - i) );
	}	while ( *aP );
	::printf( "</td></tr></table></td></tr></table>" );
	return aP;
}

// --------------------------------------------------------------------
// private		Free data
// --------------------------------------------------------------------
void	CPreviewText::Free	( void ) {
	CPreviewText::Cleanup();
}

// --------------------------------------------------------------------
// private		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewText::Cleanup	( void ) {
	::memset( &itsFile, 0, sizeof( itsFile ) );
	::memset( itsBaseUrl,	0, sizeof( itsBaseUrl ) );
	::memset( itsFileName,	0, sizeof( itsFileName ) );
	::memset( itsFilePath,	0, sizeof( itsFilePath ) );
}

// --------------------------------------------------------------------
// private		Load file information
// --------------------------------------------------------------------
char *	CPreviewText::LoadFile	( dword_t	aFileIdnt ) {
	char *	textbuff = NULL;
	try	{
		if		( aFileIdnt == 0 ) {
			throw CError( "file_idnt not defined" );
		}
		if	( aFileIdnt != itsFile.file_idnt ) {
			CMySqlConnect	db( "quest", "", "UTCMS" );
			CTableFile		tfile;
			data_file_tl	lfile;
			CMySqlWhere		w;
	
			w << "file_idnt=" << aFileIdnt;
			lfile = tfile.Select( db, w );
			if	( lfile.size() < 1 ) {
				throw CError( w.Where(), "No such file" );
			}
			itsFile = *(lfile.begin());
		}
		CCache	mycache( "preview" );
		::sprintf( 	itsFileName, "%d-file.%s",
					itsFile.file_idnt,
					itsFile.file_suff );
		mycache.MakeDirname( itsFilePath, itsFileName );
		::strcpy( itsBaseUrl, mycache.UrlBase() );

		struct stat	mystat;
		if	( ! ::stat( itsFilePath, &mystat ) ) {
			if	( itsFile.file_mtim > mystat.st_ctime ) {
				::unlink( itsFilePath );
			}
		}

		if	( ! mycache.Exist( itsFilePath ) ) {
			CStorage	storage;
			storage.Load( itsFilePath, itsFile.file_idnt );
			mycache.Cache( itsFilePath );
		}

		textbuff = ::my_load_file( itsFilePath );
	}

	catch	( CError e ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::LoadFile", e.Error() );
	}

	catch	( ... ) {
		if	( textbuff )	delete [] textbuff;
		throw CError( "CPreviewText::LoadFile", "unknown" );
	}
	return textbuff;
}

// --------------------------------------------------------------------
// EOF:	CPreviewText.cxx
// --------------------------------------------------------------------
