// --------------------------------------------------------------------
// CPreviewUpack.cxx
// Whatis:	Screenshot preview system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewUpack.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewUpack::CPreviewUpack ( void ) {
	CPreviewUpack::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewUpack::~CPreviewUpack ( void ) {
	CPreviewUpack::Free();
}

// --------------------------------------------------------------------
// public:		Load the information
// --------------------------------------------------------------------
void	CPreviewUpack::Load	( const char * 	aUnrFile ) {
	try	{
		CPreviewUpack::Free();
		itsUnFile = new CUnFile( aUnrFile );
	}

	catch	( CError e ) {
		throw CError( "CPreviewUpack::Load", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewUpack::Load", "unknown" );
	}

}

// --------------------------------------------------------------------
// public:		Try answering a question
// --------------------------------------------------------------------
bool	CPreviewUpack::Answer	( const char * aQ ) const {

	// ----------------------------------------------------------------
	// Extracting data from level info
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "pak-version" ) )		{ ::printf( "%d", itsUnFile->PackageVersion() ); return true; }
	else if	( ! ::strcmp( aQ, "pak-licmode" ) )		{ ::printf( "%d", itsUnFile->LicenseeMode() ); return true; }
	else if	( ! ::strcmp( aQ, "pak-allowdl" ) )		{ ::printf( "%s", CPreviewUpack::Unrflags( PKG_AllowDownload ) ); return true; }
	else if	( ! ::strcmp( aQ, "pak-cliopti" ) )		{ ::printf( "%s", CPreviewUpack::Unrflags( PKG_ClientOptional ) ); return true; }
	else if	( ! ::strcmp( aQ, "pak-servero" ) )		{ ::printf( "%s", CPreviewUpack::Unrflags( PKG_ServerSideOnly ) ); return true; }
	else if	( ! ::strcmp( aQ, "pak-broklin" ) )		{ ::printf( "%s", CPreviewUpack::Unrflags( PKG_BrokenLinks ) ); return true; }
	else if	( ! ::strcmp( aQ, "pak-unsecur" ) )		{ ::printf( "%s", CPreviewUpack::Unrflags( PKG_Unsecure ) ); return true; }
	else if	( ! ::strcmp( aQ, "pak-neededp" ) )		{ ::printf( "%s", CPreviewUpack::Unrflags( PKG_Need ) ); return true; }
	else if	( ! ::strcmp( aQ, "pak-guid" ) )		{ ::printf( "%s", itsUnFile->GUID() ); return true; }

	return	false;
}

// --------------------------------------------------------------------
// private		FLAGS
// --------------------------------------------------------------------
const char *	CPreviewUpack::Unrflags( dword_t	aMask ) const {
	return	(itsUnFile->PackageFlags() & aMask) ? "Yes" : "No";
}

// --------------------------------------------------------------------
// private		Free data
// --------------------------------------------------------------------
void	CPreviewUpack::Free	( void ) {
	if	( itsUnFile )	delete itsUnFile;
	CPreviewUpack::Cleanup();
}

// --------------------------------------------------------------------
// private		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewUpack::Cleanup	( void ) {
	itsUnFile = NULL;
}

// --------------------------------------------------------------------
// EOF:	CPreviewUpack.cxx
// --------------------------------------------------------------------
