// --------------------------------------------------------------------
// CSpam.cxx
// Whatis:	Class for detecting spam
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	20-APR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CSpam.hxx"
#include	"CTableSpam.hxx"
#include    "CMySqlWhere.hxx"

// --------------------------------------------------------------------
// public:	Constructor - throws if spam detected
// --------------------------------------------------------------------
CSpam::CSpam ( 	const char *	aIpAddress,		// Caller address
				const char *	aSpamLine,		// Function requested
				dword_t			aMinDelay ) {	// Minimum delay between calls

	CTableSpam		spam;
	CMySqlConnect	db( "quest", "", "UTCMS" );
	CMySqlWhere		w;
	CMySqlQuote		q;

	// Get rid of old spam
	w << "spam_time<" << (dword_t)::time(NULL);
	spam.Delete( db, w );

	// See if we have an entry already ?
	w = "";
	w << "spam_idnt='" << aIpAddress << q.Quote( aSpamLine ) << "'";
	if	( spam.Count( db, w ) > 0 ) {
		throw	CError( "Spam" );
	}

	// Add a record to database
	data_spam_t	spamdata;
	::memset( &spamdata, 0, sizeof( spamdata ) );
	::strcpy( spamdata.spam_idnt, aIpAddress );
	::strcat( spamdata.spam_idnt, q.Quote( aSpamLine ) );
	spamdata.spam_time = aMinDelay + (dword_t)::time(NULL);

	spam.Insert( db, &spamdata );
}

// --------------------------------------------------------------------
// EOF:	CSpam.cxx
// --------------------------------------------------------------------
