// --------------------------------------------------------------------
// CgiParser.cxx
// Whatis:  Utility class parse CGI to stdout
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CCgiArgs.hxx"

// --------------------------------------------------------------------
// local:	Parse raw output
// --------------------------------------------------------------------
static	bool	__parse_raw	( const CCgiArgs & aCgi, const char * aQ ) {
	if	( aCgi.Exist( aQ ) ) {
		::printf( "%s", aCgi.Arg( aQ ) );
	}
	return	false;
}

// --------------------------------------------------------------------
// local:	Parse CGI output
// --------------------------------------------------------------------
static	bool	__parse_cgi	( const CCgiArgs & aCgi, const char * aQ ) {
	if	( aCgi.Exist( aQ ) ) {
		::CGI_quote( aCgi.Arg( aQ ) );
	}
	return	false;
}

// --------------------------------------------------------------------
// local:	Parse HTML output
// --------------------------------------------------------------------
static	bool	__parse_htm	( const CCgiArgs & aCgi, const char * aQ ) {
	if	( aCgi.Exist( aQ ) ) {
		::HTML_quote( aCgi.Arg( aQ ) );
	}
	return	false;
}

// --------------------------------------------------------------------
// public:	Teh parser
// --------------------------------------------------------------------
extern	bool	cgi_parser( const CCgiArgs & aCgi, const char * aQ ) {
	if		( ! ::strncmp( aQ, "cgi.htm.", 8 ) )	return	__parse_htm( aCgi, aQ + 8 );
	else if	( ! ::strncmp( aQ, "cgi.cgi.", 8 ) )	return	__parse_cgi( aCgi, aQ + 8 );
	else if	( ! ::strncmp( aQ, "cgi.", 4 ) )		return	__parse_raw( aCgi, aQ + 4 );
	return	false;
}

// --------------------------------------------------------------------
// EOF: CCgiArgs.cxx
// --------------------------------------------------------------------
