// --------------------------------------------------------------------
// TUnrTexture.cpp
// Whatis:  Borland delphi class for accessing UTX textures
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 08-AUG-2033     Created this source
// --------------------------------------------------------------------
#include	"TUnrTexture.h"
#include	"CPicture.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CUnUtils.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
TUnrTexture::TUnrTexture	() {
	Bitmap = new TBitmap;
}

// --------------------------------------------------------------------
TUnrTexture::~TUnrTexture	() {
	if	( Bitmap )	delete Bitmap;
}

// --------------------------------------------------------------------
// public:	Interface
// --------------------------------------------------------------------
void	TUnrTexture::LoadFromFile	(	System::AnsiString	aFile,
										System::AnsiString	aTexture ) {
	try	{
		CUnUtils		utils( aFile.c_str() );
		unr_actor_tl	list = utils.ActorList( "Texture" );
		unr_actor_tli	loop;

		// Let's see if there is a texture with the given name
		for	( loop = list.begin(); loop != list.end(); loop++ ) {
			if	( aTexture == (*loop).name ) break;
		}
		if	( loop == list.end() )	throw 1;

        // We have to seek the file in place
		utils.Seek( *loop );

        // Set up a loader for the texture
		CUnTexture			mytexture( 	utils.UnFile(),
										utils.UnNameTable(),
										utils.UnExportTable(),
										utils.UnImportTable() );
        CPictureSourceUTX	myloader ( &mytexture );

		// Create a picture and load the texture into it
		CPicture			mypicture;
		mypicture.Load( myloader );

		// Convert the picture into bitmap
        Bitmap->Height = mypicture.H();
        Bitmap->Width  = mypicture.W();
	    dword_t	x, y;
    	for	( y = 0; y < mypicture.H(); y++ ) {
       		for	( x = 0; x < mypicture.W(); x++ ) {
           		Bitmap->Canvas->Pixels[x][y] = (TColor)mypicture.Pixel(x, y).DwPx();
	        }
    	}

    }

    catch	( ... ) {
		Bitmap->Height	= 0;
        Bitmap->Width	= 0;
    }
}

// --------------------------------------------------------------------
// EOF: TUnrTexture.cpp
// --------------------------------------------------------------------
