// --------------------------------------------------------------------
// TUnrTexture.hxx
// Whatis:  Borland delphi class for accessing UTX textures
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 08-AUG-2033     Created this source
// --------------------------------------------------------------------
#ifndef TUnrTexture_h
#define TUnrTexture_h
#include <vcl.h>
#pragma hdrstop

// --------------------------------------------------------------------
// Declaration of the TUnrTexture class
// --------------------------------------------------------------------
namespace Graphics {

class   TUnrTexture {

    // ----------------------------------------------------------------
    public:     // Constructor and destructor
    // ----------------------------------------------------------------
    TUnrTexture	();
    ~TUnrTexture();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operators are lethal
                // and therefore made private (won't compile if used)
    // ----------------------------------------------------------------
    TUnrTexture              ( const TUnrTexture & );
    TUnrTexture & operator = ( const TUnrTexture & );

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
	void		LoadFromFile	(	System::AnsiString	aFile,
									System::AnsiString	aTexture );

    // ----------------------------------------------------------------
    public:    // Instance data
    // ----------------------------------------------------------------
    TBitmap *	Bitmap;

};

}	// End of namespace Graphics

#endif  // #ifdef  TUnrTexture_h
// --------------------------------------------------------------------
// EOF: TUnrTexture.hxx
// --------------------------------------------------------------------
