//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUtxViewerMainDialog.h"
#include "TUtxViewerOpenDialog.h"
#include "TUnrTexture.h"
#include "CUnUtils.hxx"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TUtxViewerMainDialog *UtxViewerMainDialog;

//---------------------------------------------------------------------------
__fastcall TUtxViewerMainDialog::TUtxViewerMainDialog(TComponent* Owner)
	: TForm(Owner)
{
	itsUpdateState = 0;
}

//---------------------------------------------------------------------------
void __fastcall TUtxViewerMainDialog::CenterDisplayImage( void ) {
	UtxViewImage->Top	= UtxViewScrollBox->Height / 2 - UtxViewImage->Height / 2;
    UtxViewImage->Left	= UtxViewScrollBox->Width  / 2 - UtxViewImage->Width / 2;
}

//---------------------------------------------------------------------------
void __fastcall TUtxViewerMainDialog::ShowMyPicture( void ) {
	TUnrTexture mytexture;
	try	{
		mytexture.LoadFromFile( FileNamePanel->Caption,
        						TextureComboBox->Items->Strings[TextureComboBox->ItemIndex] );
		UtxViewImage->Picture->Bitmap->Width = mytexture.Bitmap->Width;
        UtxViewImage->Picture->Bitmap->Height= mytexture.Bitmap->Height;
	    UtxViewImage->Width	= mytexture.Bitmap->Width;
    	UtxViewImage->Height= mytexture.Bitmap->Height;
		UtxViewImage->Canvas->Draw( 0, 0, mytexture.Bitmap );
	}
    catch	( ... ) {
		UtxViewImage->Picture->Bitmap->Width = 0;
        UtxViewImage->Picture->Bitmap->Height= 0;
    	UtxViewImage->Width	= 0;
    	UtxViewImage->Height= 0;
    }
    TUtxViewerMainDialog::CenterDisplayImage();
}

//---------------------------------------------------------------------------
void __fastcall TUtxViewerMainDialog::OpenButtonClick(TObject *Sender)
{	// Open a texture file
	Application->CreateForm( __classid(TUtxViewerOpenDialog), &UtxViewerOpenDialog );
	if	( UtxViewerOpenDialog->ShowModal() == mrOk ) {
    	itsUpdateState++;
		try {
        	char			mypath[512];

			// Construct full file path from the dialog
            ::strcpy( mypath, UtxViewerOpenDialog->FileListBox->Directory.c_str() );
            ::strcat( mypath, "\\" );
            ::strcat( mypath, UtxViewerOpenDialog->Edit->Text.c_str() );

			// Get list of textures in this file
			CUnUtils		utils( mypath );
			unr_actor_tl	list = utils.ActorList( "Texture" );
			unr_actor_tli	loop;

			// Fill in the combo box
        	TextureComboBox->Items->Clear();
            for	( loop = list.begin(); loop != list.end(); loop++ ) {
				TextureComboBox->Items->Add( (*loop).name );
            }
			TextureComboBox->ItemIndex	= 0;
			FileNamePanel->Caption = mypath;
        }
        catch ( ... ) {
			FileNamePanel->Caption = "";
        	TextureComboBox->Items->Clear();
        }
    	itsUpdateState--;
    }
    UtxViewerOpenDialog->Release();
	UtxViewerOpenDialog = NULL;
	TUtxViewerMainDialog::ShowMyPicture();
}

//---------------------------------------------------------------------------
void __fastcall TUtxViewerMainDialog::CloseButtonClick(TObject *Sender)
{	// Exit the application
	Application->Terminate();
}

//---------------------------------------------------------------------------
void __fastcall TUtxViewerMainDialog::TextureComboBoxChange(
      TObject *Sender)
{	// Select another texture
	if	( itsUpdateState == 0 ) {
	    TUtxViewerMainDialog::ShowMyPicture();
    }
}

//---------------------------------------------------------------------------
void __fastcall TUtxViewerMainDialog::UtxViewScrollBoxResize(
      TObject *Sender)
{	// Resizing the image
    TUtxViewerMainDialog::CenterDisplayImage();
}

//---------------------------------------------------------------------------

