// --------------------------------------------------------------------
// CWinIniItem.hxx
// Whatis:  Windows style INI file item
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CWinIniItem_hxx
#define CWinIniItem_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------------
class CWinIniItem {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CWinIniItem		();
	~CWinIniItem	();

	// ----------------------------------------------------------------
	public:		// Copy constructors and assignment operator
	// ----------------------------------------------------------------
	CWinIniItem				( const CWinIniItem & );
	CWinIniItem operator =	( const CWinIniItem & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator ==		( const CWinIniItem & ) const;
	bool operator !=		( const CWinIniItem & ) const;
	bool operator ==		( const char * ) const;
	bool operator !=		( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Write	( FILE * ) const;
	void			Read	( FILE * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	Name		( void ) const;
	const char *	Value		( void ) const;
	dword_t			IntValue	( void ) const;
	bool			BoolValue	( void ) const;
	void			Name		( const char * aName );
	void			Value		( const char * aValue );
	void			Value		( dword_t aValue );
	void			Value		( bool aValue );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void			Cleanup	( void );
    void			Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsName;
	char *			itsValue;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CWinIniItem>		CWinIniItem_l;
typedef CWinIniItem_l::iterator       	CWinIniItem_li;
typedef CWinIniItem_l::const_iterator	CWinIniItem_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CWinIniItem.hxx
// --------------------------------------------------------------------
