// --------------------------------------------------------------------
// ICodec.hxx
// Whatis:	Interface for all codec type classes
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	22-JUN-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	ICodec_hxx
#define	ICodec_hxx

#include	"IChecksum.hxx"

// --------------------------------------------------------------------
// Structure that is passed to each codec for it's I/O (thx. Jean-loup)
// --------------------------------------------------------------------
typedef struct {
    byte_t *	next_in;	// next input byte
    dword_t		avail_in;	// number of bytes available at next_in
    dword_t		total_in;	// total nb of input bytes read so far

    byte_t *	next_out;	// next output byte should be put there
    dword_t		avail_out;	// remaining free space at next_out
    dword_t		total_out;	// total nb of bytes output so far

	IChecksum *	checksum;	// Checksum calculator
	int			complevel;	// Compression level (only for compress)

}	codec_stream_t;

// --------------------------------------------------------------------
// Declaration of the ICodec class
// --------------------------------------------------------------------
class	ICodec {

	// ----------------------------------------------------------------
	public:		// Constructor & destructor
	// ----------------------------------------------------------------
			ICodec	();
	virtual	~ICodec	();

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	virtual void	Compress	( codec_stream_t & ) = 0;
	virtual void	Decompress	( codec_stream_t & ) = 0;
	virtual bool	End			( codec_stream_t & ) = 0;

};

#endif	// #ifdef	ICodec_hxx

// --------------------------------------------------------------------
// EOF:	ICodec.hxx
// --------------------------------------------------------------------
