// --------------------------------------------------------------------
// CGz.hxx
// Whatis:	Class for reading/writing gz files
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should include this file to your code in order to use the CGz
// class library. Do not include the other files unless you know what
// you are doing.
// For information on how to manipulate the IZipStream, see
// the header file IZipStream.hxx
// --------------------------------------------------------------------
#ifndef	CGz_hxx
#define	CGz_hxx

#include	"CGzMember.hxx"

// --------------------------------------------------------------------
// Declaration of the CGz class
// --------------------------------------------------------------------
class	CGz {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGz		();
	~CGz	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGz						( const CGz & );
    CGz & operator =		( const CGz & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( const char * aZipFile );
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( const char * aZipFile );
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Call Decompress to extract data from the members
	// ----------------------------------------------------------------
	void		Decompress	( void );

	// ----------------------------------------------------------------
	// Call the Compress method after adding some members.
	// ----------------------------------------------------------------
    void		Compress	( void );


	// ----------------------------------------------------------------
	void		Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free		( void );
	void		Clear		( void );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CGzMember_l &	Members	( void ) const;

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CGzMember_l		itsMembers;
};

#endif	// #ifdef  CGz_hxx
// --------------------------------------------------------------------
// EOF:	CGz.hxx
// --------------------------------------------------------------------
