// --------------------------------------------------------------------
// CGzComment.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzComment_hxx
#define	CGzComment_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzComment class
// --------------------------------------------------------------------
class	CGzComment {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzComment	();
	~CGzComment	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzComment				( const CGzComment & );
    CGzComment & operator =	( const CGzComment & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup		( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	const char * Comment	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free		( void );
	void		Clear		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsComment;
};

#endif	// #ifdef  CGzComment_hxx
// --------------------------------------------------------------------
// EOF:	CGzComment.hxx
// --------------------------------------------------------------------
