// --------------------------------------------------------------------
// CGzExtra.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzExtra_hxx
#define	CGzExtra_hxx

#include	"CZipWord.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzExtra class
// --------------------------------------------------------------------
class	CGzExtra {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzExtra	();
	~CGzExtra	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzExtra				( const CGzExtra & );
    CGzExtra & operator =	( const CGzExtra & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup		( void );

	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	CZipWord		Size	( void ) const;
	const byte_t *	Data	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free		( void );
	void		Clear		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipWord	itsSize;
	byte_t *	itsData;
};

#endif	// #ifdef  CGzExtra_hxx
// --------------------------------------------------------------------
// EOF:	CGzExtra.hxx
// --------------------------------------------------------------------
