// --------------------------------------------------------------------
// CGzFlag.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzFlag_hxx
#define	CGzFlag_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzFlag class
// --------------------------------------------------------------------
class	CGzFlag {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzFlag	();
	~CGzFlag	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzFlag					( const CGzFlag & );
    CGzFlag & operator =	( const CGzFlag & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup				( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
    byte_t		Flag		( void ) const;
	bool		FTEXT		( void ) const;
	bool		FHCRC		( void ) const;
	bool		FEXTRA		( void ) const;
	bool		FNAME		( void ) const;
	bool		FCOMMENT	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free		( void );
	void		Clear		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	byte_t		itsFlag;
};

#endif	// #ifdef  CGzFlag_hxx
// --------------------------------------------------------------------
// EOF:	CGzFlag.hxx
// --------------------------------------------------------------------
