// --------------------------------------------------------------------
// CGzMember.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzMember_hxx
#define	CGzMember_hxx

#include	"CGzId.hxx"
#include	"CGzCm.hxx"
#include	"CGzFlag.hxx"
#include	"CGzMtime.hxx"
#include	"CGzXfl.hxx"
#include	"CGzOs.hxx"
#include	"CGzExtra.hxx"
#include	"CGzFname.hxx"
#include	"CGzComment.hxx"
#include	"CGzFhCrc.hxx"
#include	"CGzData.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzMember class
// --------------------------------------------------------------------
class	CGzMember {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzMember	();
	~CGzMember	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzMember				( const CGzMember & );
    CGzMember & operator =	( const CGzMember & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Call Decompress to extract data from the members
	// ----------------------------------------------------------------
	void		Decompress	( void );

	// ----------------------------------------------------------------
	// Call the Compress method after adding some members.
	// ----------------------------------------------------------------
    void		Compress	( void );


	// ----------------------------------------------------------------
	void		Cleanup		( void );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CGzId &		Id		( void ) const;
	const CGzCm &		Cm		( void ) const;
	const CGzFlag &		Flag	( void ) const;
	const CGzMtime &	Mtime	( void ) const;
	const CGzXfl &		Xfl		( void ) const;
	const CGzOs &		Os		( void ) const;
	const CGzExtra &	Extra	( void ) const;
	const CGzFname &	Fname	( void ) const;
	const CGzComment &	Comment	( void ) const;
	const CGzFhCrc &	FhCrc	( void ) const;
	const CGzData &		Data	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free			( void );
	void		Clear			( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CGzId		itsId;
	CGzCm		itsCm;
	CGzFlag		itsFlag;
	CGzMtime	itsMtime;
	CGzXfl		itsXfl;
	CGzOs		itsOs;
	CGzExtra	itsExtra;
	CGzFname	itsFname;
	CGzComment	itsComment;
	CGzFhCrc	itsFhCrc;
	CGzData		itsData;
};

typedef list <class CGzMember>		CGzMember_l;
typedef CGzMember_l::iterator       CGzMember_li;
typedef CGzMember_l::const_iterator	CGzMember_lci;

#endif	// #ifdef  CGzMember_hxx
// --------------------------------------------------------------------
// EOF:	CGzMember.hxx
// --------------------------------------------------------------------
