// --------------------------------------------------------------------
// CGzOs.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzOs_hxx
#define	CGzOs_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzOs class
// --------------------------------------------------------------------
class	CGzOs {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzOs	();
	~CGzOs	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzOs				( const CGzOs & );
    CGzOs & operator =	( const CGzOs & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read	( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write	( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup	( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	byte_t		Os		( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free	( void );
	void		Clear	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	byte_t		itsOs;
};

#endif	// #ifdef  CGzOs_hxx
// --------------------------------------------------------------------
// EOF:	CGzOs.hxx
// --------------------------------------------------------------------
