// --------------------------------------------------------------------
// CZipCompressionMethod.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipCompressionMethod_hxx
#define	CZipCompressionMethod_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
//	 0 - The file is stored (no compression)
//	 1 - The file is Shrunk
//	 2 - The file is Reduced with compression factor 1
//	 3 - The file is Reduced with compression factor 2
//	 4 - The file is Reduced with compression factor 3
//	 5 - The file is Reduced with compression factor 4
//	 6 - The file is Imploded
//	 7 - Reserved for Tokenizing compression algorithm
//	 8 - The file is Deflated
//	 9 - Enhanced Deflating using Deflate64(tm)
//	10 - PKWARE Date Compression Library Imploding
// --------------------------------------------------------------------
typedef	enum {
	zip_compression_method_stored		= 0,
	zip_compression_method_shrunk		= 1,
	zip_compression_method_reduced1		= 2,
	zip_compression_method_reduced2		= 3,
	zip_compression_method_reduced3		= 4,
	zip_compression_method_reduced4		= 5,
	zip_compression_method_imploded		= 6,
	zip_compression_method_tokenized	= 7,
	zip_compression_method_deflated		= 8,
	zip_compression_method_deflate64	= 9,
	zip_compression_method_datecomp		= 10
}	zip_compression_method_t;


// --------------------------------------------------------------------
// Declaration of the CZipCompressionMethod class
// --------------------------------------------------------------------
class	CZipCompressionMethod {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CZipCompressionMethod	();
	~CZipCompressionMethod	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipCompressionMethod				( const CZipCompressionMethod & );
    CZipCompressionMethod & operator =	( const CZipCompressionMethod & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read	( IZipStream & );
	void		Write	( IZipStream & );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	zip_compression_method_t	CompressionMethod (void) const;
	void						CompressionMethod (zip_compression_method_t aM );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	zip_compression_method_t	itsCompressionMethod;
};

#endif	// #ifdef  CZipCompressionMethod_hxx
// --------------------------------------------------------------------
// EOF:	CZipCompressionMethod.hxx
// --------------------------------------------------------------------
