// --------------------------------------------------------------------
// CZipDateTime.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipDateTime_hxx
#define	CZipDateTime_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Format of the MS-DOS time stamp (32-bit)
// The MS-DOS time stamp is limited to an even count of seconds, since the
// count for seconds is only 5 bits wide.
//
//   31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16
//  |<---- year-1980 --->|<- month ->|<--- day ---->|
//
//   15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
//  |<--- hour --->|<---- minute --->|<- second/2 ->|
// --------------------------------------------------------------------

// --------------------------------------------------------------------
// Declaration of the CZipDateTime class
// --------------------------------------------------------------------
class	CZipDateTime {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipDateTime	();
    CZipDateTime	( time_t aT );
	~CZipDateTime	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operators
	// ----------------------------------------------------------------
	CZipDateTime				( const CZipDateTime & );
    CZipDateTime & operator =	( const CZipDateTime & );
    CZipDateTime & operator =	( time_t );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool	operator ==	( const CZipDateTime & aC ) const;
    bool	operator !=	( const CZipDateTime & aC ) const;
    bool	operator <=	( const CZipDateTime & aC ) const;
    bool	operator >=	( const CZipDateTime & aC ) const;
    bool	operator <	( const CZipDateTime & aC ) const;
    bool	operator >	( const CZipDateTime & aC ) const;

    bool	operator ==	( time_t aT ) const;
    bool	operator !=	( time_t aT ) const;
    bool	operator <=	( time_t aT ) const;
    bool	operator >=	( time_t aT ) const;
    bool	operator <	( time_t aT ) const;
    bool	operator >	( time_t aT ) const;

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Read	( IZipStream & );
	void			Write	( IZipStream & );
	void			Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	time_t			DateTime ( void ) const;
	void			DateTime ( time_t aT );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	time_t		itsDateTime;
};

#endif	// #ifdef  CZipDateTime_hxx
// --------------------------------------------------------------------
// EOF:	CZipDateTime.hxx
// --------------------------------------------------------------------
