// --------------------------------------------------------------------
// CZipFileBlock.hxx
// Whatis:	File block of a zip file
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipFileBlock_hxx
#define	CZipFileBlock_hxx

#include	"CGz.hxx"
#include	"CZipLocalFileHeader.hxx"
#include	"CZipHeaderSignature.hxx"
#include	"CZipFileData.hxx"
#include	"CZipDataDescriptor.hxx"
#include	"CZipFlags.hxx"
#include	"CZipNotification.hxx"
#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipFileBlock class
// --------------------------------------------------------------------
class	CZipFileBlock {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipFileBlock	();
    CZipFileBlock	( const CZipFlags &, const char *, const char * );
    CZipFileBlock	( const CZipFlags &, const char *, dword_t, const char * );
    CZipFileBlock	( const CZipFlags &, IZipStream *, dword_t, const char * );
    CZipFileBlock	( const CGz &, const char *, time_t );
	~CZipFileBlock	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipFileBlock				( const CZipFileBlock & );
    CZipFileBlock & operator =	( const CZipFileBlock & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool operator == ( const CZipFileBlock & ) const;
    bool operator != ( const CZipFileBlock & ) const;
    bool operator == ( const char * ) const;
    bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read			( const CZipHeaderSignature &, IZipStream & );
	void		Write			( IZipStream & );
	void		Cleanup			( void );
    bool		Filter			( const char * aFilter );
    void		Compress		( CZipNotification * aNotify );
    void		CompressWrite	( IZipStream &, CZipNotification * );
    void		Decompress		( const CZipFlags & aFlags,
                                  const char * aTargetPath );
	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    const char *				LocalFileName	( void ) const;
	const CZipLocalFileHeader &	LocalFileHeader	( void ) const;
	const CZipFileData &		FileData		( void ) const;
	const CZipDataDescriptor &	DataDescriptor	( void ) const;
    const CZipFlags &			Flags			( void ) const;
    IZipStream *				ZipStream		( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	IZipStream *		itsZipStream;
    char *				itsLocalFileName;
	CZipLocalFileHeader	itsLocalFileHeader;
	CZipFileData		itsFileData;
	CZipDataDescriptor	itsDataDescriptor;
    CZipFlags			itsFlags;
};

typedef list <class CZipFileBlock>		CZipFileBlock_l;
typedef CZipFileBlock_l::iterator       CZipFileBlock_li;
typedef CZipFileBlock_l::const_iterator	CZipFileBlock_lci;

#endif	// #ifdef  CZipFileBlock_hxx
// --------------------------------------------------------------------
// EOF:	CZipFileBlock.hxx
// --------------------------------------------------------------------
