// --------------------------------------------------------------------
// CZipFileData.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipFileData_hxx
#define	CZipFileData_hxx

#include	"CGz.hxx"
#include	"CZipLocalFileHeader.hxx"
#include	"CZipFlags.hxx"
#include	"CZipCrc32.hxx"
#include	"CZipNotification.hxx"
#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipFileData class
// --------------------------------------------------------------------
class	CZipFileData {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipFileData	();
	CZipFileData	( const char *, dword_t );
    CZipFileData	( const CGz & );
	~CZipFileData	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipFileData				( const CZipFileData & );
    CZipFileData & operator =	( const CZipFileData & );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read		( const CZipLocalFileHeader &, IZipStream & aIn );
	void		Write		( const CZipLocalFileHeader &, IZipStream & aOut );
    void		Compress	( const CZipFlags &, IZipStream &, CZipNotification * );
    void		CompressWrite( const CZipFlags &, IZipStream &, IZipStream &, CZipNotification * );
    void		Decompress	( const CZipLocalFileHeader &, const CZipFlags &, IZipStream & );
	void		Cleanup		( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CZipDataField &	CompressedData( void ) const;
	const CZipDataField	&	CompressedFile( void ) const;
	dword_t					CompressedFileOffset( void ) const;
	dword_t					CompressedFileSize( void ) const;

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipDataField	itsCompressedData;
	CZipDataField	itsCompressedFile;
	dword_t			itsCompressedFileOffset;
	dword_t			itsCompressedFileSize;
};

#endif	// #ifdef  CZipFileData_hxx
// --------------------------------------------------------------------
// EOF:	CZipFileData.hxx
// --------------------------------------------------------------------
