// --------------------------------------------------------------------
// CZipFileHeader.hxx
// Whatis:	File header in central directory
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipFileHeader_hxx
#define	CZipFileHeader_hxx

#include	"CGz.hxx"
#include	"CZipFileBlock.hxx"
#include	"CZipHeaderSignature.hxx"
#include	"CZipVersion.hxx"
#include	"CZipHeaderBitFlag.hxx"
#include	"CZipCompressionMethod.hxx"
#include	"CZipDateTime.hxx"
#include	"CZipCrc32.hxx"
#include	"CZipDword.hxx"
#include	"CZipWord.hxx"
#include	"CZipDataField.hxx"
#include	"CZipInternalAttr.hxx"
#include	"CZipExternalAttr.hxx"
#include	"CZipFlags.hxx"

// --------------------------------------------------------------------
//	central file header signature   4 bytes  (0x02014b50)
//	version made by                 2 bytes
//	version needed to extract       2 bytes
//	general purpose bit flag        2 bytes
//	compression method              2 bytes
//	last mod file time              2 bytes
//	last mod file date              2 bytes
//	crc-32                          4 bytes
//	compressed size                 4 bytes
//	uncompressed size               4 bytes
//	filename length                 2 bytes
//	extra field length              2 bytes
//	file comment length             2 bytes
//	disk number start               2 bytes
//	internal file attributes        2 bytes
//	external file attributes        4 bytes
//	relative offset of local header 4 bytes
//	filename (variable size)
//	extra field (variable size)
//	file comment (variable size)
// --------------------------------------------------------------------


// --------------------------------------------------------------------
// Declaration of the CZipFileHeader class
// --------------------------------------------------------------------
class	CZipFileHeader {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipFileHeader	();
	CZipFileHeader	( const CZipFlags &, const CZipFileBlock &, const char * );
	CZipFileHeader	( const CZipFlags &, const char *, const char * );
	CZipFileHeader	( const CGz &, const char *, time_t );
	~CZipFileHeader	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operators
	// ----------------------------------------------------------------
	CZipFileHeader				( const CZipFileHeader & );
	CZipFileHeader & operator =	( const CZipFileHeader & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read 	( const CZipHeaderSignature &, IZipStream & );
	void		Write	( CZipFileBlock &, IZipStream & );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize		( void ) const;
    bool		Filter			( const char * aFilter = NULL )	const;
    void		AddFileComment	( const char * aComment = NULL );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CZipHeaderSignature &		Signature				( void ) const;
	const CZipVersion &				CreatorVersion			( void ) const;
	const CZipVersion &				ExtractVersion			( void ) const;
	const CZipHeaderBitFlag	&		BitFlag					( void ) const;
	const CZipCompressionMethod &	CompressionMethod		( void ) const;
	const CZipDateTime &			LastMdificationTime		( void ) const;
	const CZipCrc32	&				Crc32					( void ) const;
	const CZipDword	&				CompressedSize			( void ) const;
	const CZipDword	&				UncompressedSize		( void ) const;
	const CZipWord &				FilenameLength			( void ) const;
	const CZipWord &				ExtraFieldLength		( void ) const;
	const CZipWord &				CommentLength			( void ) const;
	const CZipWord &				DiskNumberStart			( void ) const;
	const CZipInternalAttr &		InternalFileAttributes	( void ) const;
	const CZipExternalAttr &		ExternalFileAttributes	( void ) const;
	const CZipDword	&				LocalHeaderOffset		( void ) const;
	const CZipDataField	&			FileName				( void ) const;
	const CZipDataField	&			ExtraField				( void ) const;
	const CZipDataField	&			Comment					( void ) const;

	void							LocalHeaderOffset		( dword_t );
	void							CompressedSize			( dword_t );
	void							Crc32					( dword_t );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipHeaderSignature		itsSignature;
	CZipVersion				itsCreatorVersion;
	CZipVersion				itsExtractVersion;
	CZipHeaderBitFlag		itsBitFlag;
	CZipCompressionMethod	itsCompressionMethod;
	CZipDateTime			itsLastMdificationTime;
	CZipCrc32				itsCrc32;
	CZipDword				itsCompressedSize;
	CZipDword				itsUncompressedSize;
	CZipWord				itsFilenameLength;
	CZipWord				itsExtraFieldLength;
	CZipWord				itsCommentLength;
	CZipWord				itsDiskNumberStart;
	CZipInternalAttr		itsInternalFileAttributes;
	CZipExternalAttr		itsExternalFileAttributes;
	CZipDword				itsLocalHeaderOffset;
	CZipDataField			itsFileName;
	CZipDataField			itsExtraField;
	CZipDataField			itsComment;
};

typedef list <class CZipFileHeader>			CZipFileHeader_l;
typedef CZipFileHeader_l::iterator			CZipFileHeader_li;
typedef CZipFileHeader_l::const_iterator	CZipFileHeader_lci;

#endif	// #ifdef  CZipFileHeader_hxx
// --------------------------------------------------------------------
// EOF:	CZipFileHeader.hxx
// --------------------------------------------------------------------
