// --------------------------------------------------------------------
// CZipFlags.hxx
// Whatis:	Some flags
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipFlags_hxx
#define	CZipFlags_hxx

#include	"CZipHeaderBitFlag.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipFlags class
// --------------------------------------------------------------------
class	CZipFlags {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipFlags	();
	~CZipFlags	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipFlags				( const CZipFlags & );
    CZipFlags & operator =	( const CZipFlags & );
    CZipFlags & operator =	( const char * );

	// ----------------------------------------------------------------
	public:		// Derived functions
	// ----------------------------------------------------------------
    zip_deflate_type_t	DeflateType ( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing the instance data
	// ----------------------------------------------------------------
    bool		ForgetStoredPath( void ) const;
    bool		Tar				( void ) const;
    int			CompressionLevel( void ) const;

    void		ForgetStoredPath( bool );
	void		Tar				( bool );
    void		CompressionLevel( int );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	bool        itsForgetStoredPath;
    bool		itsTar;
    int			itsCompressionLevel;

};

#endif	// #ifdef  CZipFlags_hxx
// --------------------------------------------------------------------
// EOF:	CZipFlags.hxx
// --------------------------------------------------------------------
