// --------------------------------------------------------------------
// CZipHeaderBitFlag.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipHeaderBitFlag_hxx
#define	CZipHeaderBitFlag_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
//	Bit 0: If set, indicates that the file is encrypted.
//	(For Method 6 - Imploding)
//	Bit 1: If the compression method used was type 6,
//	       Imploding, then this bit, if set, indicates
//	       an 8K sliding dictionary was used.  If clear,
//	       then a 4K sliding dictionary was used.
//	Bit 2: If the compression method used was type 6,
//	       Imploding, then this bit, if set, indicates
//	       3 Shannon-Fano trees were used to encode the
//	       sliding dictionary output.  If clear, then 2
//	       Shannon-Fano trees were used.
//	(For Methods 8 and 9 - Deflating)
//	Bit 2  Bit 1
//	  0      0    Normal (-en) compression option was used.
//	  0      1    Maximum (-exx/-ex) compression option was used.
//	  1      0    Fast (-ef) compression option was used.
//	  1      1    Super Fast (-es) compression option was used.
//	Note:  Bits 1 and 2 are undefined if the compression
//	       method is any other.
//	Bit 3: If this bit is set, the fields crc-32, compressed 
//	       size and uncompressed size are set to zero in the 
//	       local header.  The correct values are put in the 
//	       data descriptor immediately following the compressed
//	       data.  (Note: PKZIP version 2.04g for DOS only 
//	       recognizes this bit for method 8 compression, newer 
//	       versions of PKZIP recognize this bit for any 
//	       compression method.)
//	Bit 4: Reserved for use with method 8, for enhanced
//	       deflating. 
//	Bit 5: If this bit is set, this indicates that the file is 
//	       compressed patched data.  (Note: Requires PKZIP 
//	       version 2.70 or greater)
//	Bit 6: Currently unused.
//	Bit 7: Currently unused.
//	Bit 8: Currently unused.
//	Bit 9: Currently unused.
//	Bit 10: Currently unused.
//	Bit 11: Currently unused.
//	Bit 12: Reserved by PKWARE for enhanced compression.
//	Bit 13: Reserved by PKWARE.
//	Bit 14: Reserved by PKWARE.
//	Bit 15: Reserved by PKWARE.
// --------------------------------------------------------------------
typedef	enum {
	zip_deflate_type_normal		= 0,
	zip_deflate_type_maximum	= 1,
	zip_deflate_type_fast		= 2,
	zip_deflate_type_superfast	= 3
}	zip_deflate_type_t;


// --------------------------------------------------------------------
// Declaration of the CZipHeaderBitFlag class
// --------------------------------------------------------------------
class	CZipHeaderBitFlag {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CZipHeaderBitFlag	();
	~CZipHeaderBitFlag	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipHeaderBitFlag				( const CZipHeaderBitFlag & );
    CZipHeaderBitFlag & operator =	( const CZipHeaderBitFlag & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void	Read	( IZipStream & );
	void	Write	( IZipStream & );
	void	Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	bool				Encrypted			( void ) const;
	bool				ImploBigDict		( void ) const;
	bool				ImploTripleTrees	( void ) const;
	zip_deflate_type_t	DeflateType			( void ) const;
	bool				LateDetails			( void ) const;
	bool				EnchangedDeflate	( void ) const;
	bool				CompressedPatchData	( void ) const;

	void				Encrypted			( bool aV );
	void				ImploBigDict		( bool );
	void				ImploTripleTrees	( bool );
	void				DeflateType			( zip_deflate_type_t );
	void				LateDetails			( bool aV );
	void				EnchangedDeflate	( bool aV );
	void				CompressedPatchData	( bool aV );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	bool				itsEncrypted;			// Bit 0
	bool				itsImploBigDict;		// Bit 1 (implode)
	bool				itsImploTripleTrees;	// Bit 2 (implode)
	zip_deflate_type_t	itsDeflateType;			// Bit 1,2 (deflate)
	bool				itsLateDetails;			// Bit 3
	bool				itsEnchangedDeflate;	// Bit 4
	bool				itsCompressedPatchData;	// Bit 5
};

#endif	// #ifdef  CZipHeaderBitFlag_hxx
// --------------------------------------------------------------------
// EOF:	CZipHeaderBitFlag.hxx
// --------------------------------------------------------------------
