// --------------------------------------------------------------------
// CZipInternalAttr.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipInternalAttr_hxx
#define	CZipInternalAttr_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
//	The lowest bit of this field indicates, if set, that
//	the file is apparently an ASCII or text file.  If not
//	set, that the file apparently contains binary data.
//	The remaining bits are unused in version 1.0.
//	Bits 1 and 2 are reserved for use by PKWARE.
// --------------------------------------------------------------------


// --------------------------------------------------------------------
// Declaration of the CZipInternalAttr class
// --------------------------------------------------------------------
class	CZipInternalAttr {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipInternalAttr	();
	CZipInternalAttr	( word_t aV );
	~CZipInternalAttr	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipInternalAttr				( const CZipInternalAttr & aC );
	CZipInternalAttr & operator =	( const CZipInternalAttr & aC );
	CZipInternalAttr & operator =	( word_t aV );

	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	void		Read	( IZipStream & );
	void		Write	( IZipStream & );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    bool		AsciiFile	( void ) const;
    word_t		Attributes	( void ) const;
    void		Attributes	( word_t aV );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	word_t		itsAttributes;
};

#endif	// #ifdef  CZipInternalAttr_hxx
// --------------------------------------------------------------------
// EOF:	CZipInternalAttr.hxx
// --------------------------------------------------------------------
